/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.HWBColor;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.HWBColorValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PercentageValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import org.w3c.dom.DOMException;

class HWBColorImpl
extends BaseColor
implements HWBColor {
    private static final long serialVersionUID = 1L;
    private PrimitiveValue hue = null;
    private PrimitiveValue whiteness = null;
    private PrimitiveValue blackness = null;

    HWBColorImpl() {
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.HWB;
    }

    @Override
    public PrimitiveValue item(int n) {
        switch (n) {
            case 0: {
                return this.alpha;
            }
            case 1: {
                return this.getHue();
            }
            case 2: {
                return this.getWhiteness();
            }
            case 3: {
                return this.getBlackness();
            }
        }
        return null;
    }

    @Override
    void setComponent(int n, PrimitiveValue primitiveValue) {
        switch (n) {
            case 0: {
                this.setAlpha(primitiveValue);
                break;
            }
            case 1: {
                this.setHue(primitiveValue);
                break;
            }
            case 2: {
                this.setWhiteness(primitiveValue);
                break;
            }
            case 3: {
                this.setBlackness(primitiveValue);
            }
        }
    }

    @Override
    public PrimitiveValue getHue() {
        return this.hue;
    }

    public void setHue(PrimitiveValue primitiveValue) {
        this.hue = HWBColorImpl.enforceHueComponent(primitiveValue);
    }

    @Override
    public PrimitiveValue getWhiteness() {
        return this.whiteness;
    }

    public void setWhiteness(PrimitiveValue primitiveValue) {
        this.whiteness = HWBColorImpl.enforcePcntComponent(primitiveValue);
    }

    @Override
    public PrimitiveValue getBlackness() {
        return this.blackness;
    }

    public void setBlackness(PrimitiveValue primitiveValue) {
        this.blackness = HWBColorImpl.enforcePcntComponent(primitiveValue);
    }

    @Override
    boolean hasConvertibleComponents() {
        return HWBColorImpl.isConvertibleComponent(this.getWhiteness()) && HWBColorImpl.isConvertibleComponent(this.getHue()) && HWBColorImpl.isConvertibleComponent(this.getBlackness());
    }

    @Override
    void setColorComponents(double[] dArray) {
        NumberValue numberValue = NumberValue.createCSSNumberValue((short)80, (float)dArray[0]);
        numberValue.setSubproperty(true);
        numberValue.setAbsolutizedUnit();
        this.setHue(numberValue);
        PercentageValue percentageValue = new PercentageValue();
        percentageValue.setFloatValue((short)2, (float)dArray[1]);
        percentageValue.setSubproperty(true);
        percentageValue.setAbsolutizedUnit();
        this.setWhiteness(percentageValue);
        PercentageValue percentageValue2 = new PercentageValue();
        percentageValue2.setFloatValue((short)2, (float)dArray[2]);
        percentageValue2.setSubproperty(true);
        percentageValue2.setAbsolutizedUnit();
        this.setBlackness(percentageValue2);
    }

    @Override
    public double[] toNumberArray() throws DOMException {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        double[] dArray = new double[]{ColorUtil.hueDegrees((CSSTypedValue)((Object)this.getHue())), ColorUtil.floatPercent((CSSTypedValue)((Object)this.getWhiteness())), ColorUtil.floatPercent((CSSTypedValue)((Object)this.getBlackness()))};
        return dArray;
    }

    @Override
    double[] toSRGB(boolean bl) {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        double d = ColorUtil.hueDegrees((CSSTypedValue)((Object)this.getHue())) / 360.0;
        double d2 = ColorUtil.fraction((CSSTypedValue)((Object)this.getWhiteness()));
        double d3 = ColorUtil.fraction((CSSTypedValue)((Object)this.getBlackness()));
        double[] dArray = new double[3];
        this.hwbToSRGB(d, d2, d3, dArray);
        return dArray;
    }

    private void hwbToSRGB(double d, double d2, double d3, double[] dArray) {
        if (d > 1.0) {
            d -= Math.floor(d);
        } else if (d < 0.0) {
            d = d - Math.floor(d) + 1.0;
        }
        double d4 = Math.floor(d *= 6.0);
        double d5 = d - d4;
        int n = (int)d4;
        if (n % 2 == 1) {
            d5 = 1.0 - d5;
        }
        double d6 = 1.0 - d3;
        double d7 = d2 + d5 * (d6 - d2);
        switch (n) {
            case 1: {
                dArray[0] = d7;
                dArray[1] = d6;
                dArray[2] = d2;
                break;
            }
            case 2: {
                dArray[0] = d2;
                dArray[1] = d6;
                dArray[2] = d7;
                break;
            }
            case 3: {
                dArray[0] = d2;
                dArray[1] = d7;
                dArray[2] = d6;
                break;
            }
            case 4: {
                dArray[0] = d7;
                dArray[1] = d2;
                dArray[2] = d6;
                break;
            }
            case 5: {
                dArray[0] = d6;
                dArray[1] = d2;
                dArray[2] = d7;
                break;
            }
            default: {
                dArray[0] = d6;
                dArray[1] = d7;
                dArray[2] = d2;
            }
        }
    }

    @Override
    public String toString() {
        boolean bl = this.isNonOpaque();
        StringBuilder stringBuilder = new StringBuilder(20);
        stringBuilder.append("hwb(");
        this.appendHue(stringBuilder, this.hue);
        stringBuilder.append(' ').append(this.whiteness.getCssText()).append(' ').append(this.blackness.getCssText());
        if (bl) {
            stringBuilder.append(" / ");
            this.appendAlphaChannel(stringBuilder);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public String toMinifiedString() {
        boolean bl = this.isNonOpaque();
        StringBuilder stringBuilder = new StringBuilder(20);
        stringBuilder.append("hwb(");
        this.appendMinifiedHue(stringBuilder, this.hue);
        stringBuilder.append(' ').append(this.whiteness.getMinifiedCssText("color")).append(' ').append(this.blackness.getMinifiedCssText("color"));
        if (bl) {
            stringBuilder.append('/');
            this.appendAlphaChannelMinified(stringBuilder);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.blackness == null ? 0 : this.blackness.hashCode());
        n2 = 31 * n2 + (this.hue == null ? 0 : this.hue.hashCode());
        n2 = 31 * n2 + (this.whiteness == null ? 0 : this.whiteness.hashCode());
        n2 = 31 * n2 + this.alpha.hashCode();
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HWBColorImpl hWBColorImpl = (HWBColorImpl)object;
        if (this.blackness == null ? hWBColorImpl.blackness != null : !this.blackness.equals(hWBColorImpl.blackness)) {
            return false;
        }
        if (this.hue == null ? hWBColorImpl.hue != null : !this.hue.equals(hWBColorImpl.hue)) {
            return false;
        }
        if (this.whiteness == null ? hWBColorImpl.whiteness != null : !this.whiteness.equals(hWBColorImpl.whiteness)) {
            return false;
        }
        return this.alpha.equals(hWBColorImpl.alpha);
    }

    @Override
    public ColorValue packInValue() {
        return new HWBColorValue(this);
    }

    @Override
    public HWBColorImpl clone() {
        HWBColorImpl hWBColorImpl = new HWBColorImpl();
        hWBColorImpl.alpha = this.alpha.clone();
        if (this.hue != null) {
            hWBColorImpl.hue = this.hue.clone();
        }
        if (this.whiteness != null) {
            hWBColorImpl.whiteness = this.whiteness.clone();
        }
        if (this.blackness != null) {
            hWBColorImpl.blackness = this.blackness.clone();
        }
        return hWBColorImpl;
    }
}

