/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.agent.DeviceFactory;
import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSPropertyDefinition;
import io.sf.carte.doc.style.css.CSSRule;
import io.sf.carte.doc.style.css.DocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.ErrorHandler;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.FontFaceRule;
import io.sf.carte.doc.style.css.om.GroupingRule;
import io.sf.carte.doc.style.css.om.ImportRule;
import io.sf.carte.doc.style.css.om.InlineStyle;
import io.sf.carte.doc.style.css.om.MediaQueryListImpl;
import io.sf.carte.doc.style.css.om.MediaRule;
import io.sf.carte.doc.style.css.om.StyleRule;
import io.sf.carte.doc.style.css.om.SupportsRule;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRuleList;

public abstract class BaseDocumentCSSStyleSheet
extends BaseCSSStyleSheet
implements DocumentCSSStyleSheet,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String targetMedium = null;
    private Map<String, CSSPropertyDefinition> registeredPropertyMap;

    protected BaseDocumentCSSStyleSheet(String string, byte by) {
        super(null, new MediaQueryListImpl(string), null, by);
        this.targetMedium = "all".equals(string) ? null : string;
        this.registeredPropertyMap = new HashMap<String, CSSPropertyDefinition>();
    }

    @Override
    public void setHref(String string) {
        if (this.getOrigin() != 9 && this.getOrigin() != 3) {
            throw new IllegalStateException("Document sheet's href is parent document href");
        }
        super.setHref(string);
    }

    @Override
    public String getHref() {
        return this.getOwnerNode() != null ? this.getOwnerNode().getBaseURI() : super.getHref();
    }

    @Override
    public abstract CSSDocument getOwnerNode();

    public abstract void setOwnerDocument(CSSDocument var1);

    protected void copyToTarget(BaseDocumentCSSStyleSheet baseDocumentCSSStyleSheet) {
        if (baseDocumentCSSStyleSheet.getTargetMedium() == null) {
            throw new NullPointerException();
        }
        CSSDocument cSSDocument = baseDocumentCSSStyleSheet.getOwnerNode();
        CSSCanvas cSSCanvas = cSSDocument != null ? cSSDocument.getCanvas() : null;
        if (!this.getMedia().matches(baseDocumentCSSStyleSheet.getTargetMedium(), cSSCanvas)) {
            throw new IllegalArgumentException("Incompatible target medium: " + this.targetMedium);
        }
        this.copyFieldsTo(baseDocumentCSSStyleSheet);
        baseDocumentCSSStyleSheet.cssRules.ensureCapacity(this.cssRules.getLength());
        for (AbstractCSSRule abstractCSSRule : this.cssRules) {
            short s = abstractCSSRule.getType();
            if (s == 4 && !((MediaRule)abstractCSSRule).getMedia().matches(this.targetMedium, cSSCanvas) || s == 3 && !((ImportRule)abstractCSSRule).getMedia().matches(this.targetMedium, cSSCanvas)) continue;
            if (s == 18) {
                this.registerProperty((CSSPropertyDefinition)((Object)abstractCSSRule));
                continue;
            }
            baseDocumentCSSStyleSheet.cssRules.add(abstractCSSRule.clone(baseDocumentCSSStyleSheet));
        }
    }

    @Override
    protected void addLocalRule(CSSRule cSSRule) {
        if (cSSRule.getType() == 18) {
            this.registerProperty((CSSPropertyDefinition)((Object)cSSRule));
        } else {
            super.addLocalRule(cSSRule);
        }
    }

    @Override
    public String getTargetMedium() {
        return this.targetMedium;
    }

    @Override
    public abstract ComputedCSSStyle getComputedStyle(CSSElement var1, Condition var2);

    protected abstract ComputedCSSStyle createComputedCSSStyle();

    @Override
    public abstract BaseDocumentCSSStyleSheet clone();

    @Override
    public abstract BaseDocumentCSSStyleSheet clone(String var1);

    CSSPropertyDefinition getPropertyDefinition(String string) {
        return this.registeredPropertyMap.get(string);
    }

    @Override
    public void registerProperty(CSSPropertyDefinition cSSPropertyDefinition) {
        this.registeredPropertyMap.put(cSSPropertyDefinition.getName(), cSSPropertyDefinition);
    }

    protected ComputedCSSStyle computeStyle(ComputedCSSStyle computedCSSStyle, SelectorMatcher selectorMatcher, Condition condition, InlineStyle inlineStyle) {
        Serializable serializable;
        if (this.getDisabled()) {
            return computedCSSStyle;
        }
        selectorMatcher.setPseudoElement(condition);
        CSSElement cSSElement = computedCSSStyle.getOwnerNode();
        ErrorHandler errorHandler = cSSElement.getOwnerDocument().getErrorHandler();
        errorHandler.resetComputedStyleErrors(cSSElement);
        if (cSSElement.hasPresentationalHints()) {
            try {
                cSSElement.exportHintsToStyle(computedCSSStyle);
            }
            catch (DOMException dOMException) {
                errorHandler.presentationalHintError(cSSElement, dOMException);
            }
        }
        Cascade cascade = new Cascade();
        cascade.cascade(selectorMatcher, this.getTargetMedium(), this.cssRules);
        Iterator<StyleRule> iterator = cascade.iterator();
        while (iterator.hasNext()) {
            serializable = iterator.next();
            computedCSSStyle.addStyle((BaseCSSStyleDeclaration)((BaseCSSDeclarationRule)serializable).getStyle());
        }
        if (inlineStyle != null && !inlineStyle.isEmpty()) {
            computedCSSStyle.addStyle(inlineStyle);
        }
        if (cSSElement.hasOverrideStyle(condition)) {
            serializable = (BaseCSSStyleDeclaration)cSSElement.getOverrideStyle(condition);
            computedCSSStyle.addStyle((BaseCSSStyleDeclaration)serializable);
        }
        if ((serializable = this.getStyleSheetFactory().getUserImportantStyleSheet()) != null) {
            Cascade cascade2 = new Cascade();
            cascade2.cascade(selectorMatcher, this.getTargetMedium(), ((AbstractCSSStyleSheet)serializable).getCssRules());
            iterator = cascade2.iterator();
            while (iterator.hasNext()) {
                StyleRule styleRule = iterator.next();
                computedCSSStyle.addStyle((BaseCSSStyleDeclaration)styleRule.getStyle());
            }
        }
        return computedCSSStyle;
    }

    protected ComputedCSSStyle computeRevertedStyle(ComputedCSSStyle computedCSSStyle, SelectorMatcher selectorMatcher, Condition condition, BaseCSSStyleDeclaration baseCSSStyleDeclaration, byte by) {
        Serializable serializable;
        selectorMatcher.setPseudoElement(condition);
        CSSElement cSSElement = computedCSSStyle.getOwnerNode();
        ErrorHandler errorHandler = cSSElement.getOwnerDocument().getErrorHandler();
        errorHandler.resetComputedStyleErrors(cSSElement);
        if (by >= 8 && cSSElement.hasPresentationalHints()) {
            try {
                cSSElement.exportHintsToStyle(computedCSSStyle);
            }
            catch (DOMException dOMException) {
                errorHandler.presentationalHintError(cSSElement, dOMException);
            }
        }
        Cascade cascade = new Cascade();
        cascade.cascade(selectorMatcher, this.getTargetMedium(), this.cssRules, by);
        Iterator<StyleRule> iterator = cascade.iterator();
        while (iterator.hasNext()) {
            serializable = iterator.next();
            computedCSSStyle.addStyle((BaseCSSStyleDeclaration)((BaseCSSDeclarationRule)serializable).getStyle());
        }
        if (by >= 8) {
            if (baseCSSStyleDeclaration != null && !baseCSSStyleDeclaration.isEmpty()) {
                computedCSSStyle.addStyle(baseCSSStyleDeclaration);
            }
            if (cSSElement.hasOverrideStyle(condition)) {
                computedCSSStyle.addStyle((BaseCSSStyleDeclaration)cSSElement.getOverrideStyle(condition));
            }
        }
        if (by >= 3 && (serializable = this.getStyleSheetFactory().getUserImportantStyleSheet()) != null) {
            Cascade cascade2 = new Cascade();
            cascade2.cascade(selectorMatcher, this.getTargetMedium(), ((AbstractCSSStyleSheet)serializable).getCssRules());
            iterator = cascade2.iterator();
            while (iterator.hasNext()) {
                StyleRule styleRule = iterator.next();
                computedCSSStyle.addStyle((BaseCSSStyleDeclaration)styleRule.getStyle());
            }
        }
        return computedCSSStyle;
    }

    CSSCanvas getCanvas() {
        CSSCanvas cSSCanvas = this.getOwnerNode() != null ? this.getOwnerNode().getCanvas() : null;
        return cSSCanvas;
    }

    class Cascade {
        private final SortedMap<StyleRule.RuleSpecificity, LinkedList<StyleRule>> matchingStyles = new TreeMap<StyleRule.RuleSpecificity, LinkedList<StyleRule>>(new StyleRule.SpecificityComparator());

        Cascade() {
        }

        void cascade(SelectorMatcher selectorMatcher, String string, CSSRuleArrayList cSSRuleArrayList) {
            for (CSSRule cSSRule : cSSRuleArrayList) {
                BaseCSSRule baseCSSRule;
                short s = cSSRule.getType();
                if (s != 1) {
                    StyleDatabase styleDatabase;
                    if (s == 4) {
                        this.scanMediaRule(selectorMatcher, string, BaseDocumentCSSStyleSheet.this.getCanvas(), (MediaRule)cSSRule);
                        continue;
                    }
                    if (s == 5) {
                        this.processFontFaceRule((FontFaceRule)cSSRule, string);
                        continue;
                    }
                    if (s != 12) continue;
                    baseCSSRule = (SupportsRule)cSSRule;
                    DeviceFactory deviceFactory = BaseDocumentCSSStyleSheet.this.getStyleSheetFactory().getDeviceFactory();
                    if (deviceFactory == null || (styleDatabase = deviceFactory.getStyleDatabase(string)) == null || !((SupportsRule)baseCSSRule).supports(styleDatabase)) continue;
                    CSSRuleArrayList cSSRuleArrayList2 = ((GroupingRule)baseCSSRule).getCssRules();
                    this.cascade(selectorMatcher, string, cSSRuleArrayList2);
                    continue;
                }
                baseCSSRule = (StyleRule)cSSRule;
                int n = selectorMatcher.matches(((StyleRule)baseCSSRule).getSelectorList());
                if (n == -1) continue;
                this.add(((StyleRule)baseCSSRule).getSpecificity(n, selectorMatcher));
            }
        }

        private void scanMediaRule(SelectorMatcher selectorMatcher, String string, CSSCanvas cSSCanvas, MediaRule mediaRule) {
            MediaQueryList mediaQueryList = mediaRule.getMedia();
            if (string != null ? mediaQueryList.matches(string, cSSCanvas) : mediaQueryList.isAllMedia()) {
                CSSRuleList cSSRuleList = mediaRule.getCssRules();
                this.cascade(selectorMatcher, string, (CSSRuleArrayList)cSSRuleList);
            }
        }

        private void processFontFaceRule(FontFaceRule fontFaceRule, String string) {
            StyleDatabase styleDatabase;
            DeviceFactory deviceFactory = BaseDocumentCSSStyleSheet.this.getStyleSheetFactory().getDeviceFactory();
            if (deviceFactory != null && (styleDatabase = deviceFactory.getStyleDatabase(string)) != null) {
                styleDatabase.loadFontFaceRule(fontFaceRule);
            }
        }

        void add(StyleRule.RuleSpecificity ruleSpecificity) {
            if (this.matchingStyles.containsKey(ruleSpecificity)) {
                ((LinkedList)this.matchingStyles.get(ruleSpecificity)).add(ruleSpecificity.getCSSStyleRule());
            } else {
                LinkedList<StyleRule> linkedList = new LinkedList<StyleRule>();
                linkedList.add(ruleSpecificity.getCSSStyleRule());
                this.matchingStyles.put(ruleSpecificity, linkedList);
            }
        }

        public void cascade(SelectorMatcher selectorMatcher, String string, CSSRuleArrayList cSSRuleArrayList, byte by) {
            for (AbstractCSSRule abstractCSSRule : cSSRuleArrayList) {
                BaseCSSRule baseCSSRule;
                if (abstractCSSRule.getOrigin() < by) continue;
                short s = abstractCSSRule.getType();
                if (s != 1 && s != 6) {
                    StyleDatabase styleDatabase;
                    if (s == 4) {
                        this.scanMediaRule(selectorMatcher, string, BaseDocumentCSSStyleSheet.this.getCanvas(), (MediaRule)abstractCSSRule);
                        continue;
                    }
                    if (s == 5) {
                        this.processFontFaceRule((FontFaceRule)abstractCSSRule, string);
                        continue;
                    }
                    if (s != 12) continue;
                    baseCSSRule = (SupportsRule)abstractCSSRule;
                    DeviceFactory deviceFactory = BaseDocumentCSSStyleSheet.this.getStyleSheetFactory().getDeviceFactory();
                    if (deviceFactory == null || (styleDatabase = deviceFactory.getStyleDatabase(string)) == null || !((SupportsRule)baseCSSRule).supports(styleDatabase)) continue;
                    CSSRuleArrayList cSSRuleArrayList2 = ((GroupingRule)baseCSSRule).getCssRules();
                    this.cascade(selectorMatcher, string, cSSRuleArrayList2);
                    continue;
                }
                baseCSSRule = (StyleRule)abstractCSSRule;
                int n = selectorMatcher.matches(((StyleRule)baseCSSRule).getSelectorList());
                if (n == -1) continue;
                this.add(((StyleRule)baseCSSRule).getSpecificity(n, selectorMatcher));
            }
        }

        Iterator<StyleRule> iterator() {
            return new RuleIterator();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(256);
            Iterator<StyleRule> iterator = this.iterator();
            while (iterator.hasNext()) {
                StyleRule styleRule = iterator.next();
                stringBuilder.append(styleRule.getOrigin()).append(": ").append(styleRule.getCssText()).append('\n');
            }
            return stringBuilder.toString();
        }

        class RuleIterator
        implements Iterator<StyleRule> {
            private final Iterator<StyleRule.RuleSpecificity> keyit;
            private Iterator<StyleRule> currentList;

            RuleIterator() {
                this.keyit = Cascade.this.matchingStyles.keySet().iterator();
                if (this.keyit.hasNext()) {
                    this.findCurrentList();
                } else {
                    this.currentList = null;
                }
            }

            private void findCurrentList() {
                while (this.currentList == null || !this.currentList.hasNext()) {
                    if (this.keyit.hasNext()) {
                        this.currentList = ((LinkedList)Cascade.this.matchingStyles.get(this.keyit.next())).iterator();
                        continue;
                    }
                    this.currentList = null;
                    break;
                }
            }

            @Override
            public boolean hasNext() {
                return this.currentList != null;
            }

            @Override
            public StyleRule next() {
                if (this.currentList != null && this.currentList.hasNext()) {
                    StyleRule styleRule = this.currentList.next();
                    this.findCurrentList();
                    return styleRule;
                }
                throw new NoSuchElementException();
            }
        }
    }
}

