/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.math.geom;

import com.jogamp.math.FovHVHalves;
import com.jogamp.math.Matrix4f;
import com.jogamp.math.Vec3f;
import com.jogamp.math.Vec4f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.geom.Cube;

public final class Frustum {
    protected final Plane[] planes = new Plane[6];
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int BOTTOM = 2;
    public static final int TOP = 3;
    public static final int NEAR = 4;
    public static final int FAR = 5;

    public Frustum() {
        this.planes[0] = new Plane();
        this.planes[1] = new Plane();
        this.planes[2] = new Plane();
        this.planes[3] = new Plane();
        this.planes[4] = new Plane();
        this.planes[5] = new Plane();
    }

    public Frustum(Frustum frustum) {
        this.planes[0] = new Plane(frustum.planes[0]);
        this.planes[1] = new Plane(frustum.planes[1]);
        this.planes[2] = new Plane(frustum.planes[2]);
        this.planes[3] = new Plane(frustum.planes[3]);
        this.planes[4] = new Plane(frustum.planes[4]);
        this.planes[5] = new Plane(frustum.planes[5]);
    }

    public Frustum set(Frustum frustum) {
        this.planes[0].set(frustum.planes[0]);
        this.planes[1].set(frustum.planes[1]);
        this.planes[2].set(frustum.planes[2]);
        this.planes[3].set(frustum.planes[3]);
        this.planes[4].set(frustum.planes[4]);
        this.planes[5].set(frustum.planes[5]);
        return this;
    }

    public final Plane[] getPlanes() {
        return this.planes;
    }

    public Vec4f[] getPlanes(Vec4f[] vec4fArray) {
        this.planes[0].toVec4f(vec4fArray[0]);
        this.planes[1].toVec4f(vec4fArray[1]);
        this.planes[2].toVec4f(vec4fArray[2]);
        this.planes[3].toVec4f(vec4fArray[3]);
        this.planes[4].toVec4f(vec4fArray[4]);
        this.planes[5].toVec4f(vec4fArray[5]);
        return vec4fArray;
    }

    public void getPlanes(float[] fArray, int n) {
        this.planes[0].toFloats(fArray, n + 0);
        this.planes[1].toFloats(fArray, n + 4);
        this.planes[2].toFloats(fArray, n + 8);
        this.planes[3].toFloats(fArray, n + 12);
        this.planes[4].toFloats(fArray, n + 16);
        this.planes[5].toFloats(fArray, n + 20);
    }

    public final void updateByPlanes(Plane[] planeArray) {
        for (int i = 0; i < 6; ++i) {
            Plane plane = this.planes[i];
            Plane plane2 = planeArray[i];
            plane.d = plane2.d;
            System.arraycopy(plane2.n, 0, plane.n, 0, 3);
        }
    }

    public Matrix4f updateByFovDesc(Matrix4f matrix4f, FovDesc fovDesc) {
        matrix4f.setToPerspective(fovDesc.fovhv, fovDesc.zNear, fovDesc.zFar);
        this.setFromMat(matrix4f);
        return matrix4f;
    }

    public Frustum setFromMat(Matrix4f matrix4f) {
        return matrix4f.getFrustum(this);
    }

    public Frustum updateFrustumPlanes(Cube cube) {
        return cube.updateFrustumPlanes(this);
    }

    private static final boolean intersects(Plane plane, AABBox aABBox) {
        Vec3f vec3f = aABBox.getLow();
        Vec3f vec3f2 = aABBox.getHigh();
        return plane.distanceTo(vec3f.x(), vec3f.y(), vec3f.z()) > 0.0f || plane.distanceTo(vec3f2.x(), vec3f.y(), vec3f.z()) > 0.0f || plane.distanceTo(vec3f.x(), vec3f2.y(), vec3f.z()) > 0.0f || plane.distanceTo(vec3f2.x(), vec3f2.y(), vec3f.z()) > 0.0f || plane.distanceTo(vec3f.x(), vec3f.y(), vec3f2.z()) > 0.0f || plane.distanceTo(vec3f2.x(), vec3f.y(), vec3f2.z()) > 0.0f || plane.distanceTo(vec3f.x(), vec3f2.y(), vec3f2.z()) > 0.0f || plane.distanceTo(vec3f2.x(), vec3f2.y(), vec3f2.z()) > 0.0f;
    }

    public final boolean isOutside(AABBox aABBox) {
        return !Frustum.intersects(this.planes[0], aABBox) || !Frustum.intersects(this.planes[1], aABBox) || !Frustum.intersects(this.planes[2], aABBox) || !Frustum.intersects(this.planes[3], aABBox) || !Frustum.intersects(this.planes[4], aABBox) || !Frustum.intersects(this.planes[5], aABBox);
    }

    private static final boolean intersects(Plane plane, Cube cube) {
        return plane.distanceTo(cube.lbf) > 0.0f || plane.distanceTo(cube.rbf) > 0.0f || plane.distanceTo(cube.rtf) > 0.0f || plane.distanceTo(cube.ltf) > 0.0f || plane.distanceTo(cube.lbn) > 0.0f || plane.distanceTo(cube.rbn) > 0.0f || plane.distanceTo(cube.rtn) > 0.0f || plane.distanceTo(cube.ltn) > 0.0f;
    }

    public final boolean isOutside(Cube cube) {
        return !Frustum.intersects(this.planes[0], cube) || !Frustum.intersects(this.planes[1], cube) || !Frustum.intersects(this.planes[2], cube) || !Frustum.intersects(this.planes[3], cube) || !Frustum.intersects(this.planes[4], cube) || !Frustum.intersects(this.planes[5], cube);
    }

    public final Location classifyPoint(Vec3f vec3f) {
        Location location = Location.INSIDE;
        for (int i = 0; i < 6; ++i) {
            float f = this.planes[i].distanceTo(vec3f);
            if (f < 0.0f) {
                return Location.OUTSIDE;
            }
            if (f != 0.0f) continue;
            location = Location.INTERSECT;
        }
        return location;
    }

    public final boolean isOutside(Vec3f vec3f) {
        return this.planes[0].distanceTo(vec3f) < 0.0f || this.planes[1].distanceTo(vec3f) < 0.0f || this.planes[2].distanceTo(vec3f) < 0.0f || this.planes[3].distanceTo(vec3f) < 0.0f || this.planes[4].distanceTo(vec3f) < 0.0f || this.planes[5].distanceTo(vec3f) < 0.0f;
    }

    public final Location classifySphere(Vec3f vec3f, float f) {
        Location location = Location.INSIDE;
        for (int i = 0; i < 6; ++i) {
            float f2 = this.planes[i].distanceTo(vec3f);
            if (f2 < -f) {
                return Location.OUTSIDE;
            }
            if (!(f2 < f)) continue;
            location = Location.INTERSECT;
        }
        return location;
    }

    public final boolean isSphereOutside(Vec3f vec3f, float f) {
        return Location.OUTSIDE == this.classifySphere(vec3f, f);
    }

    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("Frustum[Planes[").append(System.lineSeparator()).append(" L: ").append(this.planes[0]).append(", ").append(System.lineSeparator()).append(" R: ").append(this.planes[1]).append(", ").append(System.lineSeparator()).append(" B: ").append(this.planes[2]).append(", ").append(System.lineSeparator()).append(" T: ").append(this.planes[3]).append(", ").append(System.lineSeparator()).append(" N: ").append(this.planes[4]).append(", ").append(System.lineSeparator()).append(" F: ").append(this.planes[5]).append("], ").append(System.lineSeparator()).append("]");
        return stringBuilder;
    }

    public String toString() {
        return this.toString(null).toString();
    }

    public static class FovDesc {
        public final FovHVHalves fovhv;
        public final float zNear;
        public final float zFar;

        public FovDesc(FovHVHalves fovHVHalves, float f, float f2) throws IllegalArgumentException {
            if (f <= 0.0f || f2 <= f) {
                throw new IllegalArgumentException("Requirements zNear > 0 and zFar > zNear, but zNear " + f + ", zFar " + f2);
            }
            this.fovhv = fovHVHalves;
            this.zNear = f;
            this.zFar = f2;
        }

        public final String toString() {
            return "FrustumFovDesc[" + this.fovhv.toStringInDegrees() + ", Z[" + this.zNear + " - " + this.zFar + "]]";
        }
    }

    public static enum Location {
        OUTSIDE,
        INSIDE,
        INTERSECT;

    }

    public static class Plane {
        public final Vec3f n;
        public float d;

        public Plane() {
            this.n = new Vec3f();
            this.d = 0.0f;
        }

        public Plane(Plane plane) {
            this.n = new Vec3f(plane.n);
            this.d = plane.d;
        }

        public Plane set(Plane plane) {
            this.n.set(plane.n);
            this.d = plane.d;
            return this;
        }

        public Plane set(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3) {
            Vec3f vec3f4 = vec3f2.minus(vec3f);
            Vec3f vec3f5 = vec3f3.minus(vec3f);
            this.n.cross(vec3f4, vec3f5).normalize();
            this.d = this.n.copy().scale(-1.0f).dot(vec3f);
            return this;
        }

        public Plane set(Vec3f vec3f, Vec3f vec3f2) {
            this.n.set(vec3f);
            this.d = vec3f.scale(-1.0f).dot(vec3f2);
            return this;
        }

        public Vec4f toVec4f(Vec4f vec4f) {
            vec4f.set(this.n, this.d);
            return vec4f;
        }

        public void toFloats(float[] fArray, int n) {
            fArray[n + 0] = this.n.x();
            fArray[n + 1] = this.n.y();
            fArray[n + 2] = this.n.z();
            fArray[n + 3] = this.d;
        }

        public final float distanceTo(float f, float f2, float f3) {
            return this.n.x() * f + this.n.y() * f2 + this.n.z() * f3 + this.d;
        }

        public final float distanceTo(Vec3f vec3f) {
            return this.n.dot(vec3f) + this.d;
        }

        public String toString() {
            return "Plane[ [ " + this.n + " ], " + this.d + "]";
        }
    }
}

