/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Token;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.EmptyExpression;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.Scope;
import org.mozilla.javascript.ast.StringLiteral;

public abstract class AstNode
extends Node
implements Comparable<AstNode> {
    protected int position = -1;
    protected int length = 1;
    protected AstNode parent;
    protected AstNode inlineComment;
    private static Map<Integer, String> operatorNames = new HashMap<Integer, String>();
    private static final int MAX_INDENT = 42;
    private static final String[] INDENTATIONS = new String[43];

    public AstNode() {
        super(-1);
    }

    public AstNode(int n) {
        this();
        this.position = n;
    }

    public AstNode(int n, int n2) {
        this();
        this.position = n;
        this.length = n2;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public int getAbsolutePosition() {
        int n = this.position;
        for (AstNode astNode = this.parent; astNode != null; astNode = astNode.getParent()) {
            n += astNode.getPosition();
        }
        return n;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public void setBounds(int n, int n2) {
        this.setPosition(n);
        this.setLength(n2 - n);
    }

    public void setRelative(int n) {
        this.position -= n;
    }

    public AstNode getParent() {
        return this.parent;
    }

    public void setParent(AstNode astNode) {
        if (astNode == this.parent) {
            return;
        }
        if (this.parent != null) {
            this.setRelative(-this.parent.getAbsolutePosition());
        }
        this.parent = astNode;
        if (astNode != null) {
            this.setRelative(astNode.getAbsolutePosition());
        }
    }

    public void addChild(AstNode astNode) {
        this.assertNotNull(astNode);
        int n = astNode.getPosition() + astNode.getLength();
        this.setLength(n - this.getPosition());
        this.addChildToBack(astNode);
        astNode.setParent(this);
    }

    public AstRoot getAstRoot() {
        AstNode astNode;
        for (astNode = this; astNode != null && !(astNode instanceof AstRoot); astNode = astNode.getParent()) {
        }
        return (AstRoot)astNode;
    }

    public abstract String toSource(int var1);

    public String toSource() {
        return this.toSource(0);
    }

    public String makeIndent(int n) {
        n = Math.min(42, Math.max(0, n));
        return INDENTATIONS[n];
    }

    public String shortName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(".");
        return string.substring(n + 1);
    }

    public static String operatorToString(int n) {
        String string = operatorNames.get(n);
        if (string == null) {
            throw new IllegalArgumentException("Invalid operator: " + n);
        }
        return string;
    }

    public abstract void visit(NodeVisitor var1);

    @Override
    public boolean hasSideEffects() {
        switch (this.getType()) {
            case -1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 30: 
            case 31: 
            case 35: 
            case 37: 
            case 38: 
            case 50: 
            case 51: 
            case 56: 
            case 57: 
            case 65: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 84: 
            case 85: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 110: 
            case 111: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 157: 
            case 158: 
            case 162: 
            case 163: 
            case 169: {
                return true;
            }
        }
        return false;
    }

    protected void assertNotNull(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("arg cannot be null");
        }
    }

    protected <T extends AstNode> void printList(List<T> list, StringBuilder stringBuilder) {
        int n = list.size();
        int n2 = 0;
        for (AstNode astNode : list) {
            stringBuilder.append(astNode.toSource(0));
            if (n2++ < n - 1) {
                stringBuilder.append(", ");
                continue;
            }
            if (!(astNode instanceof EmptyExpression)) continue;
            stringBuilder.append(",");
        }
    }

    public static RuntimeException codeBug() throws RuntimeException {
        throw Kit.codeBug();
    }

    public FunctionNode getEnclosingFunction() {
        AstNode astNode;
        for (astNode = this.getParent(); astNode != null && !(astNode instanceof FunctionNode); astNode = astNode.getParent()) {
        }
        return (FunctionNode)astNode;
    }

    public Scope getEnclosingScope() {
        AstNode astNode;
        for (astNode = this.getParent(); astNode != null && !(astNode instanceof Scope); astNode = astNode.getParent()) {
        }
        return (Scope)astNode;
    }

    @Override
    public int compareTo(AstNode astNode) {
        int n;
        int n2;
        if (this.equals(astNode)) {
            return 0;
        }
        int n3 = this.getAbsolutePosition();
        if (n3 < (n2 = astNode.getAbsolutePosition())) {
            return -1;
        }
        if (n2 < n3) {
            return 1;
        }
        int n4 = this.getLength();
        if (n4 < (n = astNode.getLength())) {
            return -1;
        }
        if (n < n4) {
            return 1;
        }
        return this.hashCode() - astNode.hashCode();
    }

    public int depth() {
        return this.parent == null ? 0 : 1 + this.parent.depth();
    }

    @Override
    public int getLineno() {
        if (this.lineno != -1) {
            return this.lineno;
        }
        if (this.parent != null) {
            return this.parent.getLineno();
        }
        return -1;
    }

    public String debugPrint() {
        DebugPrintVisitor debugPrintVisitor = new DebugPrintVisitor(new StringBuilder(1000));
        this.visit(debugPrintVisitor);
        return debugPrintVisitor.toString();
    }

    public AstNode getInlineComment() {
        return this.inlineComment;
    }

    public void setInlineComment(AstNode astNode) {
        this.inlineComment = astNode;
    }

    static {
        operatorNames.put(52, "in");
        operatorNames.put(32, "typeof");
        operatorNames.put(53, "instanceof");
        operatorNames.put(31, "delete");
        operatorNames.put(92, ",");
        operatorNames.put(107, ":");
        operatorNames.put(108, "||");
        operatorNames.put(109, "&&");
        operatorNames.put(110, "++");
        operatorNames.put(111, "--");
        operatorNames.put(9, "|");
        operatorNames.put(10, "^");
        operatorNames.put(11, "&");
        operatorNames.put(12, "==");
        operatorNames.put(13, "!=");
        operatorNames.put(14, "<");
        operatorNames.put(16, ">");
        operatorNames.put(15, "<=");
        operatorNames.put(17, ">=");
        operatorNames.put(18, "<<");
        operatorNames.put(19, ">>");
        operatorNames.put(20, ">>>");
        operatorNames.put(21, "+");
        operatorNames.put(22, "-");
        operatorNames.put(23, "*");
        operatorNames.put(24, "/");
        operatorNames.put(25, "%");
        operatorNames.put(75, "**");
        operatorNames.put(26, "!");
        operatorNames.put(27, "~");
        operatorNames.put(28, "+");
        operatorNames.put(29, "-");
        operatorNames.put(46, "===");
        operatorNames.put(47, "!==");
        operatorNames.put(93, "=");
        operatorNames.put(94, "|=");
        operatorNames.put(96, "&=");
        operatorNames.put(97, "<<=");
        operatorNames.put(98, ">>=");
        operatorNames.put(99, ">>>=");
        operatorNames.put(100, "+=");
        operatorNames.put(101, "-=");
        operatorNames.put(102, "*=");
        operatorNames.put(103, "/=");
        operatorNames.put(104, "%=");
        operatorNames.put(95, "^=");
        operatorNames.put(105, "**=");
        operatorNames.put(130, "void");
        StringBuilder stringBuilder = new StringBuilder();
        AstNode.INDENTATIONS[0] = stringBuilder.toString();
        for (int i = 1; i <= 42; ++i) {
            stringBuilder.append("  ");
            AstNode.INDENTATIONS[i] = stringBuilder.toString();
        }
    }

    protected static class DebugPrintVisitor
    implements NodeVisitor {
        private StringBuilder buffer;
        private static final int DEBUG_INDENT = 2;

        public DebugPrintVisitor(StringBuilder stringBuilder) {
            this.buffer = stringBuilder;
        }

        public String toString() {
            return this.buffer.toString();
        }

        private static String makeIndent(int n) {
            StringBuilder stringBuilder = new StringBuilder(2 * n);
            for (int i = 0; i < 2 * n; ++i) {
                stringBuilder.append(" ");
            }
            return stringBuilder.toString();
        }

        @Override
        public boolean visit(AstNode astNode) {
            int n = astNode.getType();
            String string = Token.typeToName(n);
            this.buffer.append(astNode.getAbsolutePosition()).append("\t");
            this.buffer.append(DebugPrintVisitor.makeIndent(astNode.depth()));
            this.buffer.append(string).append(" ");
            this.buffer.append(astNode.getPosition()).append(" ");
            this.buffer.append(astNode.getLength());
            if (n == 39) {
                this.buffer.append(" ").append(((Name)astNode).getIdentifier());
            } else if (n == 41) {
                this.buffer.append(" ").append(((StringLiteral)astNode).getValue(true));
            }
            this.buffer.append("\n");
            return true;
        }
    }

    public static class PositionComparator
    implements Comparator<AstNode>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(AstNode astNode, AstNode astNode2) {
            return astNode.position - astNode2.position;
        }
    }
}

