/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ES6Iterator;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.FieldAndMethods;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.InterfaceAdapter;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeDate;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.SymbolScriptable;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class NativeJavaObject
implements Scriptable,
SymbolScriptable,
Wrapper,
Serializable {
    private static final long serialVersionUID = -6948590651130498591L;
    private static final int JSTYPE_UNDEFINED = 0;
    private static final int JSTYPE_NULL = 1;
    private static final int JSTYPE_BOOLEAN = 2;
    private static final int JSTYPE_NUMBER = 3;
    private static final int JSTYPE_STRING = 4;
    private static final int JSTYPE_JAVA_CLASS = 5;
    private static final int JSTYPE_JAVA_OBJECT = 6;
    private static final int JSTYPE_JAVA_ARRAY = 7;
    private static final int JSTYPE_OBJECT = 8;
    private static final int JSTYPE_BIGINT = 9;
    static final byte CONVERSION_TRIVIAL = 1;
    static final byte CONVERSION_NONTRIVIAL = 0;
    static final byte CONVERSION_NONE = 99;
    private static Callable symbol_iterator = (context, scriptable, scriptable2, objectArray) -> {
        if (!(scriptable2 instanceof NativeJavaObject)) {
            throw ScriptRuntime.typeErrorById("msg.incompat.call", SymbolKey.ITERATOR);
        }
        Object object = ((NativeJavaObject)scriptable2).javaObject;
        if (!(object instanceof Iterable)) {
            throw ScriptRuntime.typeErrorById("msg.incompat.call", SymbolKey.ITERATOR);
        }
        return new JavaIterableIterator(scriptable, (Iterable)object);
    };
    protected Scriptable prototype;
    protected Scriptable parent;
    protected transient Object javaObject;
    protected transient Class<?> staticType;
    protected transient JavaMembers members;
    private transient Map<String, FieldAndMethods> fieldAndMethods;
    protected transient boolean isAdapter;
    private static final Object COERCED_INTERFACE_KEY = "Coerced Interface";
    private static Method adapter_writeAdapterObject;
    private static Method adapter_readAdapterObject;

    static void init(ScriptableObject scriptableObject, boolean bl) {
        JavaIterableIterator.init(scriptableObject, bl);
    }

    public NativeJavaObject() {
    }

    public NativeJavaObject(Scriptable scriptable, Object object, Class<?> clazz) {
        this(scriptable, object, clazz, false);
    }

    public NativeJavaObject(Scriptable scriptable, Object object, Class<?> clazz, boolean bl) {
        this.parent = scriptable;
        this.javaObject = object;
        this.staticType = clazz;
        this.isAdapter = bl;
        this.initMembers();
    }

    protected void initMembers() {
        Class<?> clazz = this.javaObject != null ? this.javaObject.getClass() : this.staticType;
        this.members = JavaMembers.lookupClass(this.parent, clazz, this.staticType, this.isAdapter);
        this.fieldAndMethods = this.members.getFieldAndMethodsObjects(this, this.javaObject, false);
    }

    @Override
    public boolean has(String string, Scriptable scriptable) {
        return this.members.has(string, false);
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        return false;
    }

    @Override
    public boolean has(Symbol symbol, Scriptable scriptable) {
        return SymbolKey.ITERATOR.equals(symbol) && this.javaObject instanceof Iterable;
    }

    @Override
    public Object get(String string, Scriptable scriptable) {
        FieldAndMethods fieldAndMethods;
        if (this.fieldAndMethods != null && (fieldAndMethods = this.fieldAndMethods.get(string)) != null) {
            return fieldAndMethods;
        }
        return this.members.get(this, string, this.javaObject, false);
    }

    @Override
    public Object get(Symbol symbol, Scriptable scriptable) {
        if (SymbolKey.ITERATOR.equals(symbol) && this.javaObject instanceof Iterable) {
            return symbol_iterator;
        }
        return Scriptable.NOT_FOUND;
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        throw this.members.reportMemberNotFound(Integer.toString(n));
    }

    @Override
    public void put(String string, Scriptable scriptable, Object object) {
        if (this.prototype == null || this.members.has(string, false)) {
            this.members.put(this, string, this.javaObject, object, false);
        } else {
            this.prototype.put(string, this.prototype, object);
        }
    }

    @Override
    public void put(Symbol symbol, Scriptable scriptable, Object object) {
        String string = symbol.toString();
        if (this.prototype == null || this.members.has(string, false)) {
            this.members.put(this, string, this.javaObject, object, false);
        } else if (this.prototype instanceof SymbolScriptable) {
            ((SymbolScriptable)((Object)this.prototype)).put(symbol, this.prototype, object);
        }
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        throw this.members.reportMemberNotFound(Integer.toString(n));
    }

    @Override
    public boolean hasInstance(Scriptable scriptable) {
        return false;
    }

    @Override
    public void delete(String string) {
    }

    @Override
    public void delete(Symbol symbol) {
    }

    @Override
    public void delete(int n) {
    }

    @Override
    public Scriptable getPrototype() {
        if (this.prototype == null && this.javaObject instanceof String) {
            return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(this.parent), TopLevel.Builtins.String);
        }
        return this.prototype;
    }

    @Override
    public void setPrototype(Scriptable scriptable) {
        this.prototype = scriptable;
    }

    @Override
    public Scriptable getParentScope() {
        return this.parent;
    }

    @Override
    public void setParentScope(Scriptable scriptable) {
        this.parent = scriptable;
    }

    @Override
    public Object[] getIds() {
        return this.members.getIds(false);
    }

    @Deprecated
    public static Object wrap(Scriptable scriptable, Object object, Class<?> clazz) {
        Context context = Context.getContext();
        return context.getWrapFactory().wrap(context, scriptable, object, clazz);
    }

    @Override
    public Object unwrap() {
        return this.javaObject;
    }

    @Override
    public String getClassName() {
        return "JavaObject";
    }

    @Override
    public Object getDefaultValue(Class<?> clazz) {
        Object object;
        if (clazz == null) {
            if (this.javaObject instanceof Boolean) {
                clazz = ScriptRuntime.BooleanClass;
            }
            if (this.javaObject instanceof Number) {
                clazz = ScriptRuntime.NumberClass;
            }
        }
        if (clazz == null || clazz == ScriptRuntime.StringClass) {
            object = this.javaObject.toString();
        } else {
            String string;
            if (clazz == ScriptRuntime.BooleanClass) {
                string = "booleanValue";
            } else if (clazz == ScriptRuntime.NumberClass) {
                string = "doubleValue";
            } else {
                throw Context.reportRuntimeErrorById("msg.default.value", new Object[0]);
            }
            Object object2 = this.get(string, (Scriptable)this);
            if (object2 instanceof Function) {
                Function function = (Function)object2;
                object = function.call(Context.getContext(), function.getParentScope(), this, ScriptRuntime.emptyArgs);
            } else {
                boolean bl;
                object = clazz == ScriptRuntime.NumberClass && this.javaObject instanceof Boolean ? ((bl = ((Boolean)this.javaObject).booleanValue()) ? (Number)ScriptRuntime.wrapNumber(1.0) : (Number)ScriptRuntime.zeroObj) : this.javaObject.toString();
            }
        }
        return object;
    }

    public static boolean canConvert(Object object, Class<?> clazz) {
        int n = NativeJavaObject.getConversionWeight(object, clazz);
        return n < 99;
    }

    static int getConversionWeight(Object object, Class<?> clazz) {
        int n = NativeJavaObject.getJSTypeCode(object);
        switch (n) {
            case 0: {
                if (clazz != ScriptRuntime.StringClass && clazz != ScriptRuntime.ObjectClass) break;
                return 1;
            }
            case 1: {
                if (clazz.isPrimitive()) break;
                return 1;
            }
            case 2: {
                if (clazz == Boolean.TYPE) {
                    return 1;
                }
                if (clazz == ScriptRuntime.BooleanClass) {
                    return 2;
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    return 3;
                }
                if (clazz != ScriptRuntime.StringClass) break;
                return 4;
            }
            case 3: 
            case 9: {
                if (clazz.isPrimitive()) {
                    if (clazz == Double.TYPE) {
                        return 1;
                    }
                    if (clazz == Boolean.TYPE) break;
                    return 1 + NativeJavaObject.getSizeRank(clazz);
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return 9;
                }
                if (clazz == ScriptRuntime.BigIntegerClass) {
                    return 10;
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    return 11;
                }
                if (!ScriptRuntime.NumberClass.isAssignableFrom(clazz)) break;
                return 2;
            }
            case 4: {
                if (clazz == ScriptRuntime.StringClass) {
                    return 1;
                }
                if (clazz.isInstance(object)) {
                    return 2;
                }
                if (!clazz.isPrimitive()) break;
                if (clazz == Character.TYPE) {
                    return 3;
                }
                if (clazz == Boolean.TYPE) break;
                return 4;
            }
            case 5: {
                if (clazz == ScriptRuntime.ClassClass) {
                    return 1;
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    return 3;
                }
                if (clazz != ScriptRuntime.StringClass) break;
                return 4;
            }
            case 6: 
            case 7: {
                Object object2 = object;
                if (object2 instanceof Wrapper) {
                    object2 = ((Wrapper)object2).unwrap();
                }
                if (clazz.isInstance(object2)) {
                    return 0;
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return 2;
                }
                if (!clazz.isPrimitive() || clazz == Boolean.TYPE) break;
                return n == 7 ? 99 : 2 + NativeJavaObject.getSizeRank(clazz);
            }
            case 8: {
                if (clazz != ScriptRuntime.ObjectClass && clazz.isInstance(object)) {
                    return 1;
                }
                if (clazz.isArray()) {
                    if (!(object instanceof NativeArray)) break;
                    return 2;
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    return 3;
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return 4;
                }
                if (clazz == ScriptRuntime.DateClass) {
                    if (!(object instanceof NativeDate)) break;
                    return 1;
                }
                if (clazz.isInterface()) {
                    if (object instanceof NativeFunction) {
                        return 1;
                    }
                    if (object instanceof NativeObject) {
                        return 2;
                    }
                    return 12;
                }
                if (!clazz.isPrimitive() || clazz == Boolean.TYPE) break;
                return 4 + NativeJavaObject.getSizeRank(clazz);
            }
        }
        return 99;
    }

    static int getSizeRank(Class<?> clazz) {
        if (clazz == Double.TYPE) {
            return 1;
        }
        if (clazz == Float.TYPE) {
            return 2;
        }
        if (clazz == Long.TYPE) {
            return 3;
        }
        if (clazz == Integer.TYPE) {
            return 4;
        }
        if (clazz == Short.TYPE) {
            return 5;
        }
        if (clazz == Character.TYPE) {
            return 6;
        }
        if (clazz == Byte.TYPE) {
            return 7;
        }
        if (clazz == Boolean.TYPE) {
            return 99;
        }
        return 8;
    }

    private static int getJSTypeCode(Object object) {
        if (object == null) {
            return 1;
        }
        if (object == Undefined.instance) {
            return 0;
        }
        if (object instanceof CharSequence) {
            return 4;
        }
        if (object instanceof BigInteger) {
            return 9;
        }
        if (object instanceof Number) {
            return 3;
        }
        if (object instanceof Boolean) {
            return 2;
        }
        if (object instanceof Scriptable) {
            if (object instanceof NativeJavaClass) {
                return 5;
            }
            if (object instanceof NativeJavaArray) {
                return 7;
            }
            if (object instanceof Wrapper) {
                return 6;
            }
            return 8;
        }
        if (object instanceof Class) {
            return 5;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            return 7;
        }
        return 6;
    }

    @Deprecated
    public static Object coerceType(Class<?> clazz, Object object) {
        return NativeJavaObject.coerceTypeImpl(clazz, object);
    }

    static Object coerceTypeImpl(Class<?> clazz, Object object) {
        if (object != null && object.getClass() == clazz) {
            return object;
        }
        int n = NativeJavaObject.getJSTypeCode(object);
        switch (n) {
            case 1: {
                if (clazz.isPrimitive()) {
                    NativeJavaObject.reportConversionError(object, clazz);
                }
                return null;
            }
            case 0: {
                if (clazz == ScriptRuntime.StringClass || clazz == ScriptRuntime.ObjectClass) {
                    return "undefined";
                }
                NativeJavaObject.reportConversionError("undefined", clazz);
                break;
            }
            case 2: {
                if (clazz == Boolean.TYPE || clazz == ScriptRuntime.BooleanClass || clazz == ScriptRuntime.ObjectClass) {
                    return object;
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return object.toString();
                }
                NativeJavaObject.reportConversionError(object, clazz);
                break;
            }
            case 3: 
            case 9: {
                if (clazz == ScriptRuntime.StringClass) {
                    return ScriptRuntime.toString(object);
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    long l;
                    Context context = Context.getCurrentContext();
                    if (context != null && context.hasFeature(18) && (double)(l = Math.round(NativeJavaObject.toDouble(object))) == NativeJavaObject.toDouble(object)) {
                        return NativeJavaObject.coerceToNumber(Long.TYPE, object);
                    }
                    return NativeJavaObject.coerceToNumber(n == 9 ? BigInteger.class : Double.TYPE, object);
                }
                if (clazz.isPrimitive() && clazz != Boolean.TYPE || ScriptRuntime.NumberClass.isAssignableFrom(clazz)) {
                    return NativeJavaObject.coerceToNumber(clazz, object);
                }
                NativeJavaObject.reportConversionError(object, clazz);
                break;
            }
            case 4: {
                if (clazz == ScriptRuntime.StringClass || clazz.isInstance(object)) {
                    return object.toString();
                }
                if (clazz == Character.TYPE || clazz == ScriptRuntime.CharacterClass) {
                    if (((CharSequence)object).length() == 1) {
                        return Character.valueOf(((CharSequence)object).charAt(0));
                    }
                    return NativeJavaObject.coerceToNumber(clazz, object);
                }
                if (clazz.isPrimitive() && clazz != Boolean.TYPE || ScriptRuntime.NumberClass.isAssignableFrom(clazz)) {
                    return NativeJavaObject.coerceToNumber(clazz, object);
                }
                NativeJavaObject.reportConversionError(object, clazz);
                break;
            }
            case 5: {
                if (object instanceof Wrapper) {
                    object = ((Wrapper)object).unwrap();
                }
                if (clazz == ScriptRuntime.ClassClass || clazz == ScriptRuntime.ObjectClass) {
                    return object;
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return object.toString();
                }
                NativeJavaObject.reportConversionError(object, clazz);
                break;
            }
            case 6: 
            case 7: {
                if (object instanceof Wrapper) {
                    object = ((Wrapper)object).unwrap();
                }
                if (clazz.isPrimitive()) {
                    if (clazz == Boolean.TYPE) {
                        NativeJavaObject.reportConversionError(object, clazz);
                    }
                    return NativeJavaObject.coerceToNumber(clazz, object);
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return object.toString();
                }
                if (clazz.isInstance(object)) {
                    return object;
                }
                NativeJavaObject.reportConversionError(object, clazz);
                break;
            }
            case 8: {
                if (clazz == ScriptRuntime.StringClass) {
                    return ScriptRuntime.toString(object);
                }
                if (clazz.isPrimitive()) {
                    if (clazz == Boolean.TYPE) {
                        NativeJavaObject.reportConversionError(object, clazz);
                    }
                    return NativeJavaObject.coerceToNumber(clazz, object);
                }
                if (clazz.isInstance(object)) {
                    return object;
                }
                if (clazz == ScriptRuntime.DateClass && object instanceof NativeDate) {
                    double d = ((NativeDate)object).getJSTimeValue();
                    return new Date((long)d);
                }
                if (clazz.isArray() && object instanceof NativeArray) {
                    NativeArray nativeArray = (NativeArray)object;
                    long l = nativeArray.getLength();
                    Class<?> clazz2 = clazz.getComponentType();
                    Object object2 = Array.newInstance(clazz2, (int)l);
                    int n2 = 0;
                    while ((long)n2 < l) {
                        try {
                            Array.set(object2, n2, NativeJavaObject.coerceTypeImpl(clazz2, nativeArray.get(n2, (Scriptable)nativeArray)));
                        }
                        catch (EvaluatorException evaluatorException) {
                            NativeJavaObject.reportConversionError(object, clazz);
                        }
                        ++n2;
                    }
                    return object2;
                }
                if (object instanceof Wrapper) {
                    if (clazz.isInstance(object = ((Wrapper)object).unwrap())) {
                        return object;
                    }
                    NativeJavaObject.reportConversionError(object, clazz);
                    break;
                }
                if (clazz.isInterface() && (object instanceof NativeObject || object instanceof Callable && object instanceof ScriptableObject)) {
                    return NativeJavaObject.createInterfaceAdapter(clazz, (ScriptableObject)object);
                }
                NativeJavaObject.reportConversionError(object, clazz);
            }
        }
        return object;
    }

    protected static Object createInterfaceAdapter(Class<?> clazz, ScriptableObject scriptableObject) {
        Object object = Kit.makeHashKeyFromPair(COERCED_INTERFACE_KEY, clazz);
        Object object2 = scriptableObject.getAssociatedValue(object);
        if (object2 != null) {
            return object2;
        }
        Context context = Context.getContext();
        Object object3 = InterfaceAdapter.create(context, clazz, scriptableObject);
        object3 = scriptableObject.associateValue(object, object3);
        return object3;
    }

    private static Object coerceToNumber(Class<?> clazz, Object object) {
        Class<?> clazz2 = object.getClass();
        if (clazz == Character.TYPE || clazz == ScriptRuntime.CharacterClass) {
            if (clazz2 == ScriptRuntime.CharacterClass) {
                return object;
            }
            return Character.valueOf((char)NativeJavaObject.toInteger(object, ScriptRuntime.CharacterClass, 0.0, 65535.0));
        }
        if (clazz == ScriptRuntime.ObjectClass || clazz == ScriptRuntime.DoubleClass || clazz == Double.TYPE) {
            if (clazz2 == ScriptRuntime.DoubleClass) {
                return object;
            }
            return NativeJavaObject.toDouble(object);
        }
        if (clazz == ScriptRuntime.BigIntegerClass) {
            if (clazz2 == ScriptRuntime.BigIntegerClass) {
                return object;
            }
            return ScriptRuntime.toBigInt(object);
        }
        if (clazz == ScriptRuntime.FloatClass || clazz == Float.TYPE) {
            if (clazz2 == ScriptRuntime.FloatClass) {
                return object;
            }
            double d = NativeJavaObject.toDouble(object);
            if (Double.isInfinite(d) || Double.isNaN(d) || d == 0.0) {
                return Float.valueOf((float)d);
            }
            double d2 = Math.abs(d);
            if (d2 < (double)1.4E-45f) {
                return Float.valueOf(d > 0.0 ? 0.0f : -0.0f);
            }
            if (d2 > 3.4028234663852886E38) {
                return Float.valueOf(d > 0.0 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY);
            }
            return Float.valueOf((float)d);
        }
        if (clazz == ScriptRuntime.IntegerClass || clazz == Integer.TYPE) {
            if (clazz2 == ScriptRuntime.IntegerClass) {
                return object;
            }
            return (int)NativeJavaObject.toInteger(object, ScriptRuntime.IntegerClass, -2.147483648E9, 2.147483647E9);
        }
        if (clazz == ScriptRuntime.LongClass || clazz == Long.TYPE) {
            if (clazz2 == ScriptRuntime.LongClass) {
                return object;
            }
            double d = Double.longBitsToDouble(4890909195324358655L);
            double d3 = Double.longBitsToDouble(-4332462841530417152L);
            return NativeJavaObject.toInteger(object, ScriptRuntime.LongClass, d3, d);
        }
        if (clazz == ScriptRuntime.ShortClass || clazz == Short.TYPE) {
            if (clazz2 == ScriptRuntime.ShortClass) {
                return object;
            }
            return (short)NativeJavaObject.toInteger(object, ScriptRuntime.ShortClass, -32768.0, 32767.0);
        }
        if (clazz == ScriptRuntime.ByteClass || clazz == Byte.TYPE) {
            if (clazz2 == ScriptRuntime.ByteClass) {
                return object;
            }
            return (byte)NativeJavaObject.toInteger(object, ScriptRuntime.ByteClass, -128.0, 127.0);
        }
        return NativeJavaObject.toDouble(object);
    }

    private static double toDouble(Object object) {
        Method method;
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            return ScriptRuntime.toNumber((String)object);
        }
        if (object instanceof Scriptable) {
            if (object instanceof Wrapper) {
                return NativeJavaObject.toDouble(((Wrapper)object).unwrap());
            }
            return ScriptRuntime.toNumber(object);
        }
        try {
            method = object.getClass().getMethod("doubleValue", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        catch (SecurityException securityException) {
            method = null;
        }
        if (method != null) {
            try {
                return ((Number)method.invoke(object, (Object[])null)).doubleValue();
            }
            catch (IllegalAccessException illegalAccessException) {
                NativeJavaObject.reportConversionError(object, Double.TYPE);
            }
            catch (InvocationTargetException invocationTargetException) {
                NativeJavaObject.reportConversionError(object, Double.TYPE);
            }
        }
        return ScriptRuntime.toNumber(object.toString());
    }

    private static long toInteger(Object object, Class<?> clazz, double d, double d2) {
        double d3 = NativeJavaObject.toDouble(object);
        if (Double.isInfinite(d3) || Double.isNaN(d3)) {
            NativeJavaObject.reportConversionError(ScriptRuntime.toString(object), clazz);
        }
        if ((d3 = d3 > 0.0 ? Math.floor(d3) : Math.ceil(d3)) < d || d3 > d2) {
            NativeJavaObject.reportConversionError(ScriptRuntime.toString(object), clazz);
        }
        return (long)d3;
    }

    static void reportConversionError(Object object, Class<?> clazz) {
        throw Context.reportRuntimeErrorById("msg.conversion.not.allowed", String.valueOf(object), JavaMembers.javaSignature(clazz));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeBoolean(this.isAdapter);
        if (this.isAdapter) {
            if (adapter_writeAdapterObject == null) {
                throw new IOException();
            }
            Object[] objectArray = new Object[]{this.javaObject, objectOutputStream};
            try {
                adapter_writeAdapterObject.invoke(null, objectArray);
            }
            catch (Exception exception) {
                throw new IOException();
            }
        } else {
            objectOutputStream.writeObject(this.javaObject);
        }
        if (this.staticType != null) {
            objectOutputStream.writeObject(this.staticType.getName());
        } else {
            objectOutputStream.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object[] objectArray;
        objectInputStream.defaultReadObject();
        this.isAdapter = objectInputStream.readBoolean();
        if (this.isAdapter) {
            if (adapter_readAdapterObject == null) {
                throw new ClassNotFoundException();
            }
            objectArray = new Object[]{this, objectInputStream};
            try {
                this.javaObject = adapter_readAdapterObject.invoke(null, objectArray);
            }
            catch (Exception exception) {
                throw new IOException();
            }
        } else {
            this.javaObject = objectInputStream.readObject();
        }
        this.staticType = (objectArray = (Object[])objectInputStream.readObject()) != null ? Class.forName((String)objectArray) : null;
        this.initMembers();
    }

    public boolean equals(Object object) {
        return object != null && object.getClass().equals(this.getClass()) && Objects.equals(((NativeJavaObject)object).javaObject, this.javaObject);
    }

    public int hashCode() {
        return this.javaObject == null ? 0 : this.javaObject.hashCode();
    }

    static {
        Class[] classArray = new Class[2];
        Class<?> clazz = Kit.classOrNull("org.mozilla.javascript.JavaAdapter");
        if (clazz != null) {
            try {
                classArray[0] = ScriptRuntime.ObjectClass;
                classArray[1] = Kit.classOrNull("java.io.ObjectOutputStream");
                adapter_writeAdapterObject = clazz.getMethod("writeAdapterObject", classArray);
                classArray[0] = ScriptRuntime.ScriptableClass;
                classArray[1] = Kit.classOrNull("java.io.ObjectInputStream");
                adapter_readAdapterObject = clazz.getMethod("readAdapterObject", classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                adapter_writeAdapterObject = null;
                adapter_readAdapterObject = null;
            }
        }
    }

    private static final class JavaIterableIterator
    extends ES6Iterator {
        private static final long serialVersionUID = 1L;
        private static final String ITERATOR_TAG = "JavaIterableIterator";
        private Iterator iterator;

        static void init(ScriptableObject scriptableObject, boolean bl) {
            ES6Iterator.init(scriptableObject, bl, new JavaIterableIterator(), ITERATOR_TAG);
        }

        private JavaIterableIterator() {
        }

        JavaIterableIterator(Scriptable scriptable, Iterable iterable) {
            super(scriptable, ITERATOR_TAG);
            this.iterator = iterable.iterator();
        }

        @Override
        public String getClassName() {
            return "Java Iterable Iterator";
        }

        @Override
        protected boolean isDone(Context context, Scriptable scriptable) {
            return !this.iterator.hasNext();
        }

        @Override
        protected Object nextValue(Context context, Scriptable scriptable) {
            if (!this.iterator.hasNext()) {
                return Undefined.instance;
            }
            Object e = this.iterator.next();
            return context.getWrapFactory().wrap(context, this, e, e == null ? null : e.getClass());
        }

        @Override
        protected String getTag() {
            return ITERATOR_TAG;
        }
    }
}

