/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

public class LambdaFunction
extends BaseFunction {
    private static final long serialVersionUID = -8388132362854748293L;
    private final transient Callable target;
    private final String name;
    private final int length;

    public LambdaFunction(Scriptable scriptable, String string, int n, Callable callable) {
        this.target = callable;
        this.name = string;
        this.length = n;
        ScriptRuntime.setFunctionProtoAndParent((BaseFunction)this, Context.getCurrentContext(), scriptable);
        this.setupDefaultPrototype();
    }

    public LambdaFunction(Scriptable scriptable, int n, Callable callable) {
        this.target = callable;
        this.length = n;
        this.name = "";
        ScriptRuntime.setFunctionProtoAndParent((BaseFunction)this, Context.getCurrentContext(), scriptable);
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        return this.target.call(context, scriptable, scriptable2, objectArray);
    }

    @Override
    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        throw ScriptRuntime.typeErrorById("msg.no.new", this.getFunctionName());
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getArity() {
        return this.length;
    }

    @Override
    public String getFunctionName() {
        return this.name;
    }
}

