/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.dom;

import io.sf.carte.echosvg.dom.AbstractCharacterData;
import io.sf.carte.echosvg.dom.AbstractNode;
import io.sf.carte.echosvg.dom.util.XMLSupport;
import io.sf.carte.echosvg.xml.XMLUtilities;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class AbstractText
extends AbstractCharacterData
implements Text {
    private static final long serialVersionUID = 1L;

    @Override
    public Text splitText(int n) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{(int)this.getNodeType(), this.getNodeName()});
        }
        String string = this.getNodeValue();
        if (n < 0 || n >= string.length()) {
            throw this.createDOMException((short)1, "offset", new Object[]{n});
        }
        Node node = this.getParentNode();
        if (node == null) {
            throw this.createDOMException((short)1, "need.parent", new Object[0]);
        }
        String string2 = string.substring(n);
        Text text = this.createTextNode(string2);
        Node node2 = this.getNextSibling();
        if (node2 != null) {
            node.insertBefore(text, node2);
        } else {
            node.appendChild(text);
        }
        this.setNodeValue(string.substring(0, n));
        return text;
    }

    protected Node getPreviousLogicallyAdjacentTextNode(Node node) {
        Node node2;
        Node node3 = node.getParentNode();
        for (node2 = node.getPreviousSibling(); node2 == null && node3 != null && node3.getNodeType() == 5; node2 = node2.getPreviousSibling()) {
            node2 = node3;
            node3 = node2.getParentNode();
        }
        while (node2 != null && node2.getNodeType() == 5) {
            node2 = node2.getLastChild();
        }
        if (node2 == null) {
            return null;
        }
        short s = node2.getNodeType();
        if (s == 3 || s == 4) {
            return node2;
        }
        return null;
    }

    protected Node getNextLogicallyAdjacentTextNode(Node node) {
        Node node2;
        Node node3 = node.getParentNode();
        for (node2 = node.getNextSibling(); node2 == null && node3 != null && node3.getNodeType() == 5; node2 = node2.getNextSibling()) {
            node2 = node3;
            node3 = node2.getParentNode();
        }
        while (node2 != null && node2.getNodeType() == 5) {
            node2 = node2.getFirstChild();
        }
        if (node2 == null) {
            return null;
        }
        short s = node2.getNodeType();
        if (s == 3 || s == 4) {
            return node2;
        }
        return null;
    }

    @Override
    public String getWholeText() {
        StringBuilder stringBuilder = new StringBuilder();
        Node node = this;
        while (node != null) {
            stringBuilder.insert(0, node.getNodeValue());
            node = this.getPreviousLogicallyAdjacentTextNode(node);
        }
        node = this.getNextLogicallyAdjacentTextNode(this);
        while (node != null) {
            stringBuilder.append(node.getNodeValue());
            node = this.getNextLogicallyAdjacentTextNode(node);
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isElementContentWhitespace() {
        int n = this.nodeValue.length();
        for (int i = 0; i < n; ++i) {
            if (XMLUtilities.isXMLSpace((char)this.nodeValue.charAt(i))) continue;
            return false;
        }
        Node node = this.getParentNode();
        if (node.getNodeType() == 1) {
            String string = XMLSupport.getXMLSpace((Element)node);
            return !string.equals("preserve");
        }
        return true;
    }

    @Override
    public Text replaceWholeText(String string) throws DOMException {
        Node node;
        Node node2 = this.getPreviousLogicallyAdjacentTextNode(this);
        while (node2 != null) {
            node = (AbstractNode)node2;
            if (node.isReadonly()) {
                throw this.createDOMException((short)7, "readonly.node", new Object[]{(int)node2.getNodeType(), node2.getNodeName()});
            }
            node2 = this.getPreviousLogicallyAdjacentTextNode(node2);
        }
        node2 = this.getNextLogicallyAdjacentTextNode(this);
        while (node2 != null) {
            node = (AbstractNode)node2;
            if (node.isReadonly()) {
                throw this.createDOMException((short)7, "readonly.node", new Object[]{(int)node2.getNodeType(), node2.getNodeName()});
            }
            node2 = this.getNextLogicallyAdjacentTextNode(node2);
        }
        node2 = this.getParentNode();
        node = this.getPreviousLogicallyAdjacentTextNode(this);
        while (node != null) {
            node2.removeChild(node);
            node = this.getPreviousLogicallyAdjacentTextNode(node);
        }
        node = this.getNextLogicallyAdjacentTextNode(this);
        while (node != null) {
            node2.removeChild(node);
            node = this.getNextLogicallyAdjacentTextNode(node);
        }
        if (this.isReadonly()) {
            node = this.createTextNode(string);
            node2.replaceChild(node, this);
            return node;
        }
        this.setNodeValue(string);
        return this;
    }

    @Override
    public String getTextContent() {
        if (this.isElementContentWhitespace()) {
            return "";
        }
        return this.getNodeValue();
    }

    protected abstract Text createTextNode(String var1);
}

