/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.NodeFilter;
import io.sf.carte.doc.dom.TreeWalker;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

class TreeWalkerImpl
implements TreeWalker {
    private final AbstractDOMNode rootNode;
    private AbstractDOMNode currentNode;
    private boolean begin = true;
    private final int whatToShow;
    private final NodeFilter nodeFilter;

    TreeWalkerImpl(AbstractDOMNode abstractDOMNode, int n, NodeFilter nodeFilter) {
        this.rootNode = abstractDOMNode;
        this.nodeFilter = nodeFilter;
        this.whatToShow = n;
        this.currentNode = abstractDOMNode;
    }

    @Override
    public AbstractDOMNode getRoot() {
        return this.rootNode;
    }

    @Override
    public int getWhatToShow() {
        return this.whatToShow;
    }

    @Override
    public NodeFilter getNodeFilter() {
        return this.nodeFilter;
    }

    @Override
    public DOMNode getCurrentNode() {
        return this.currentNode;
    }

    @Override
    public void setCurrentNode(Node node) {
        if (node == null) {
            throw new DOMException(9, "current node cannot be null");
        }
        Node node2 = node;
        while (node != null) {
            if (node2 == this.rootNode) {
                this.currentNode = (AbstractDOMNode)node;
                if (node == node2) {
                    this.begin = true;
                }
                return;
            }
            node2 = node2.getParentNode();
        }
        throw new DOMException(9, "This implementation does not support setting the current node outside of the root-based tree");
    }

    private boolean isToShow(Node node) {
        int n = NodeFilter.maskTable[node.getNodeType() - 1];
        return (this.whatToShow & n) == n;
    }

    private short filter(Node node) {
        if (!this.isToShow(node)) {
            return 3;
        }
        return this.nodeFilter == null ? (short)1 : this.nodeFilter.acceptNode(node);
    }

    @Override
    public DOMNode nextNode() {
        AbstractDOMNode abstractDOMNode;
        if (this.currentNode == this.rootNode) {
            if (!this.begin) {
                return null;
            }
            abstractDOMNode = this.findNext(this.currentNode);
            if (abstractDOMNode != this.rootNode) {
                this.currentNode = abstractDOMNode;
                this.begin = false;
            } else {
                abstractDOMNode = null;
            }
        } else {
            abstractDOMNode = this.findNext();
            if (abstractDOMNode != this.rootNode) {
                this.currentNode = abstractDOMNode;
            } else {
                abstractDOMNode = null;
            }
        }
        return abstractDOMNode;
    }

    private AbstractDOMNode findNext() {
        AbstractDOMNode abstractDOMNode = this.nextVisible(this.currentNode);
        return this.findNext(abstractDOMNode);
    }

    private AbstractDOMNode findNext(AbstractDOMNode abstractDOMNode) {
        short s;
        AbstractDOMNode abstractDOMNode2 = this.nextNode(abstractDOMNode);
        while (abstractDOMNode2 != this.rootNode && (s = this.filter(abstractDOMNode2)) != 1) {
            if (s != 3) {
                abstractDOMNode2 = this.nextSiblingOrParent(abstractDOMNode2);
                continue;
            }
            abstractDOMNode2 = this.nextNode(abstractDOMNode2);
        }
        return abstractDOMNode2;
    }

    private AbstractDOMNode highestInvisibleAncestorOrMe(AbstractDOMNode abstractDOMNode) {
        AbstractDOMNode abstractDOMNode2 = abstractDOMNode;
        while (abstractDOMNode2 != this.rootNode) {
            if (this.filter(abstractDOMNode2) == 2) {
                abstractDOMNode = abstractDOMNode2;
            }
            if ((abstractDOMNode2 = (AbstractDOMNode)abstractDOMNode2.getParentNode()) != null) continue;
            break;
        }
        return abstractDOMNode;
    }

    private AbstractDOMNode nextVisible(AbstractDOMNode abstractDOMNode) {
        AbstractDOMNode abstractDOMNode2 = null;
        AbstractDOMNode abstractDOMNode3 = abstractDOMNode;
        while (abstractDOMNode3 != this.rootNode) {
            if (this.filter(abstractDOMNode3) == 2) {
                abstractDOMNode2 = abstractDOMNode3;
            }
            if ((abstractDOMNode3 = (AbstractDOMNode)abstractDOMNode3.getParentNode()) != null) continue;
        }
        if (abstractDOMNode2 != null) {
            if (abstractDOMNode2 != this.rootNode) {
                abstractDOMNode = this.nextSiblingOrParent(abstractDOMNode2);
                while (abstractDOMNode != this.rootNode) {
                    short s = this.filter(abstractDOMNode);
                    if (s == 2) {
                        abstractDOMNode = this.nextSiblingOrParent(abstractDOMNode);
                        continue;
                    }
                    if (s == 3) {
                        abstractDOMNode = this.nextNode(abstractDOMNode);
                        continue;
                    }
                    break;
                }
            } else {
                abstractDOMNode = this.rootNode;
            }
        }
        return abstractDOMNode;
    }

    private AbstractDOMNode nextNode(AbstractDOMNode abstractDOMNode) {
        AbstractDOMNode abstractDOMNode2 = abstractDOMNode.getNodeList().getFirst();
        if (abstractDOMNode2 == null) {
            abstractDOMNode2 = abstractDOMNode != this.rootNode || this.rootNode.getNodeType() == 2 ? this.nextSiblingOrParent(abstractDOMNode) : abstractDOMNode;
        }
        return abstractDOMNode2;
    }

    private AbstractDOMNode nextSiblingOrParent(AbstractDOMNode abstractDOMNode) {
        AbstractDOMNode abstractDOMNode2 = abstractDOMNode.nextSibling;
        if (abstractDOMNode2 == null) {
            AbstractDOMNode abstractDOMNode3 = abstractDOMNode.parentNode();
            if (abstractDOMNode3 != this.rootNode && abstractDOMNode3 != null) {
                return this.nextSiblingOrParent(abstractDOMNode3);
            }
            abstractDOMNode2 = this.rootNode;
        }
        return abstractDOMNode2;
    }

    private boolean isAccepted(AbstractDOMNode abstractDOMNode) {
        return this.filter(abstractDOMNode) == 1;
    }

    @Override
    public DOMNode previousNode() {
        AbstractDOMNode abstractDOMNode = this.findPrevious();
        if (abstractDOMNode != null) {
            if (abstractDOMNode != this.rootNode) {
                this.currentNode = abstractDOMNode;
            } else if (this.isAccepted(abstractDOMNode)) {
                this.currentNode = abstractDOMNode;
                this.begin = true;
            } else {
                abstractDOMNode = null;
            }
        }
        return abstractDOMNode;
    }

    private AbstractDOMNode findPrevious() {
        AbstractDOMNode abstractDOMNode = this.highestInvisibleAncestorOrMe(this.currentNode);
        return this.findPrevious(abstractDOMNode);
    }

    private AbstractDOMNode findPrevious(AbstractDOMNode abstractDOMNode) {
        short s;
        if (abstractDOMNode == this.rootNode) {
            AbstractDOMNode abstractDOMNode2 = null;
            if (!this.begin && (abstractDOMNode2 = abstractDOMNode.getNodeList().getLast()) != null && !this.isAccepted(abstractDOMNode2)) {
                abstractDOMNode2 = this.findPrevious(abstractDOMNode2);
            }
            return abstractDOMNode2;
        }
        AbstractDOMNode abstractDOMNode3 = this.previousNode(abstractDOMNode);
        while (abstractDOMNode3 != this.rootNode && abstractDOMNode3 != null && (s = this.filter(abstractDOMNode3)) != 1) {
            abstractDOMNode3 = this.previousNode(abstractDOMNode3);
        }
        return abstractDOMNode3;
    }

    private AbstractDOMNode previousNode(AbstractDOMNode abstractDOMNode) {
        AbstractDOMNode abstractDOMNode2 = abstractDOMNode.previousSibling;
        if (abstractDOMNode2 == null) {
            abstractDOMNode2 = abstractDOMNode.parentNode();
        } else {
            while (true) {
                AbstractDOMNode abstractDOMNode3;
                short s;
                if ((s = this.filter(abstractDOMNode2)) != 2) {
                    abstractDOMNode3 = abstractDOMNode2.getNodeList().getLast();
                    if (abstractDOMNode3 == null) break;
                    abstractDOMNode2 = abstractDOMNode3;
                    continue;
                }
                abstractDOMNode3 = abstractDOMNode2.previousSibling;
                if (abstractDOMNode3 == null) break;
                abstractDOMNode2 = abstractDOMNode3;
            }
        }
        return abstractDOMNode2;
    }

    @Override
    public DOMNode firstChild() {
        AbstractDOMNode abstractDOMNode = this.findFirstChild();
        if (abstractDOMNode != null) {
            this.currentNode = abstractDOMNode;
        }
        return abstractDOMNode;
    }

    private AbstractDOMNode findFirstChild() {
        AbstractDOMNode abstractDOMNode;
        AbstractDOMNode abstractDOMNode2 = this.highestInvisibleAncestorOrMe(this.currentNode);
        if (abstractDOMNode2 == this.currentNode) {
            abstractDOMNode = abstractDOMNode2.getNodeList().getFirst();
            while (abstractDOMNode != null && !this.isAccepted(abstractDOMNode)) {
                abstractDOMNode = abstractDOMNode.nextSibling;
            }
        } else {
            abstractDOMNode = null;
        }
        return abstractDOMNode;
    }

    @Override
    public DOMNode lastChild() {
        AbstractDOMNode abstractDOMNode = this.findLastChild();
        if (abstractDOMNode != null) {
            this.currentNode = abstractDOMNode;
        }
        return abstractDOMNode;
    }

    private AbstractDOMNode findLastChild() {
        AbstractDOMNode abstractDOMNode;
        AbstractDOMNode abstractDOMNode2 = this.highestInvisibleAncestorOrMe(this.currentNode);
        if (abstractDOMNode2 == this.currentNode) {
            abstractDOMNode = abstractDOMNode2.getNodeList().getLast();
            while (abstractDOMNode != null && !this.isAccepted(abstractDOMNode)) {
                abstractDOMNode = abstractDOMNode.previousSibling;
            }
        } else {
            abstractDOMNode = null;
        }
        return abstractDOMNode;
    }

    @Override
    public DOMNode nextSibling() {
        AbstractDOMNode abstractDOMNode;
        if (this.currentNode != this.rootNode) {
            abstractDOMNode = this.findNextSibling();
            if (abstractDOMNode != null) {
                this.currentNode = abstractDOMNode;
            }
        } else {
            abstractDOMNode = null;
        }
        return abstractDOMNode;
    }

    private AbstractDOMNode findNextSibling() {
        AbstractDOMNode abstractDOMNode;
        AbstractDOMNode abstractDOMNode2 = this.highestInvisibleAncestorOrMe(this.currentNode);
        if (abstractDOMNode2 == this.currentNode) {
            abstractDOMNode = abstractDOMNode2.nextSibling;
            while (abstractDOMNode != null && !this.isAccepted(abstractDOMNode)) {
                abstractDOMNode = abstractDOMNode.nextSibling;
            }
        } else {
            abstractDOMNode = null;
        }
        return abstractDOMNode;
    }

    @Override
    public DOMNode previousSibling() {
        AbstractDOMNode abstractDOMNode;
        if (this.currentNode != this.rootNode) {
            abstractDOMNode = this.findPreviousSibling();
            if (abstractDOMNode != null) {
                this.currentNode = abstractDOMNode;
            }
        } else {
            abstractDOMNode = null;
        }
        return abstractDOMNode;
    }

    private AbstractDOMNode findPreviousSibling() {
        AbstractDOMNode abstractDOMNode;
        AbstractDOMNode abstractDOMNode2 = this.highestInvisibleAncestorOrMe(this.currentNode);
        if (abstractDOMNode2 == this.currentNode) {
            abstractDOMNode = abstractDOMNode2.previousSibling;
            while (abstractDOMNode != null && !this.isAccepted(abstractDOMNode)) {
                abstractDOMNode = abstractDOMNode.previousSibling;
            }
        } else {
            abstractDOMNode = null;
        }
        return abstractDOMNode;
    }

    @Override
    public DOMNode parentNode() {
        AbstractDOMNode abstractDOMNode = this.findParentNode();
        if (abstractDOMNode != null) {
            if (abstractDOMNode != this.rootNode) {
                this.currentNode = abstractDOMNode;
            } else if (this.isAccepted(abstractDOMNode)) {
                this.currentNode = abstractDOMNode;
                this.begin = true;
            } else {
                abstractDOMNode = null;
            }
        }
        return abstractDOMNode;
    }

    private AbstractDOMNode findParentNode() {
        AbstractDOMNode abstractDOMNode;
        AbstractDOMNode abstractDOMNode2 = this.currentNode != this.rootNode ? ((abstractDOMNode = this.highestInvisibleAncestorOrMe(this.currentNode)) == this.currentNode || abstractDOMNode != this.rootNode ? (AbstractDOMNode)abstractDOMNode.getParentNode() : null) : null;
        return abstractDOMNode2;
    }

    @Override
    public org.w3c.dom.traversal.NodeFilter getFilter() {
        if (this.nodeFilter instanceof org.w3c.dom.traversal.NodeFilter) {
            return (org.w3c.dom.traversal.NodeFilter)((Object)this.nodeFilter);
        }
        return null;
    }

    @Override
    public boolean getExpandEntityReferences() {
        return false;
    }
}

