/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc;

import io.sf.carte.doc.DOMTokenList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.w3c.dom.DOMException;

public class DOMTokenListImpl
implements DOMTokenList,
Serializable {
    private static final long serialVersionUID = 1L;
    private final LinkedList<String> tokenset = new LinkedList();

    @Override
    public int getLength() {
        return this.tokenset.size();
    }

    @Override
    public String getValue() {
        int n = this.tokenset.size();
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            return this.tokenset.getFirst();
        }
        StringBuilder stringBuilder = new StringBuilder(32 + 12 * this.tokenset.size());
        Iterator iterator = this.tokenset.iterator();
        stringBuilder.append((String)iterator.next());
        while (iterator.hasNext()) {
            stringBuilder.append(' ').append((String)iterator.next());
        }
        return stringBuilder.toString();
    }

    @Override
    public String getSortedValue() {
        int n = this.tokenset.size();
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            return this.tokenset.getFirst();
        }
        TreeSet<String> treeSet = new TreeSet<String>(this.tokenset);
        StringBuilder stringBuilder = new StringBuilder(32 + 12 * this.tokenset.size());
        Iterator<String> iterator = treeSet.iterator();
        stringBuilder.append(iterator.next());
        while (iterator.hasNext()) {
            stringBuilder.append(' ').append(iterator.next());
        }
        return stringBuilder.toString();
    }

    public void setValue(String string) throws DOMException {
        if (string == null) {
            throw new DOMException(12, "Token cannot be null");
        }
        this.tokenset.clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            this.tokenset.add(stringTokenizer.nextToken());
        }
    }

    @Override
    public String item(int n) {
        if (n < 0 || n >= this.tokenset.size()) {
            return null;
        }
        return this.tokenset.get(n);
    }

    @Override
    public boolean contains(String string) {
        return this.tokenset.contains(string);
    }

    @Override
    public Iterator<String> iterator() {
        return this.tokenset.iterator();
    }

    @Override
    public boolean containsAll(DOMTokenList dOMTokenList) throws DOMException {
        if (dOMTokenList == null) {
            throw new DOMException(12, "Argument is null.");
        }
        for (String string : dOMTokenList) {
            if (this.contains(string)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<String> collection) {
        return this.tokenset.containsAll(collection);
    }

    @Override
    public void add(String string) throws DOMException {
        if (string == null || string.length() == 0) {
            throw new DOMException(12, "Token cannot be empty.");
        }
        if (string.indexOf(32) != -1) {
            throw new DOMException(5, "Token cannot contain spaces");
        }
        if (!this.tokenset.contains(string)) {
            this.tokenset.add(string);
        }
    }

    @Override
    public void remove(String string) throws DOMException {
        if (string == null || string.length() == 0) {
            throw new DOMException(12, "Token cannot be empty");
        }
        if (string.indexOf(32) != -1) {
            throw new DOMException(5, "Token cannot contain spaces");
        }
        this.tokenset.remove(string);
    }

    @Override
    public boolean toggle(String string) throws DOMException {
        if (string == null || string.length() == 0) {
            throw new DOMException(12, "Token cannot be empty");
        }
        if (string.indexOf(32) != -1) {
            throw new DOMException(5, "Token cannot contain spaces");
        }
        if (!this.tokenset.remove(string)) {
            return this.tokenset.add(string);
        }
        return false;
    }

    @Override
    public void replace(String string, String string2) throws DOMException {
        if (string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
            throw new DOMException(12, "Tokens cannot be empty");
        }
        if (string.indexOf(32) != -1 || string2.indexOf(32) != -1) {
            throw new DOMException(5, "Tokens cannot contain spaces");
        }
        int n = this.tokenset.indexOf(string);
        if (n != -1) {
            this.tokenset.set(n, string2);
        }
    }
}

