/*
 * Decompiled with CFR 0.152.
 */
package io.sf.jclf.text.format;

import io.sf.jclf.text.LoremIpsum;
import io.sf.jclf.text.format.ObjectFormat;
import io.sf.jclf.text.format.SpecParsingException;

public class StringFormat
extends ObjectFormat {
    public StringFormat() {
        this.precision = 0;
    }

    @Override
    protected char setFormat(String string) throws SpecParsingException {
        char c = super.setFormat(string);
        if (this.precision != 0 && this.width > this.precision) {
            throw new SpecParsingException("Width is greater than precision at a String format");
        }
        return c;
    }

    @Override
    public String format(Object object) {
        String string = object instanceof String ? (String)object : (object instanceof String[] ? ((String[])object)[0] : object.toString());
        int n = string.length();
        if (this.precision > n) {
            n = this.precision;
        }
        StringBuilder stringBuilder = new StringBuilder(n + 20);
        if (this.ralign) {
            this.rightAppend(stringBuilder, string, ' ', this.width, this.precision);
        } else {
            this.leftAppend(stringBuilder, string, ' ', this.width, this.precision);
        }
        return stringBuilder.toString();
    }

    private void leftAppend(StringBuilder stringBuilder, String string, char c, int n, int n2) {
        int n3 = string.length();
        if (n != 0 && n3 < n) {
            int n4 = n - n3;
            stringBuilder.append(string);
            for (int i = 0; i < n4; ++i) {
                stringBuilder.append(c);
            }
            return;
        }
        if (n2 == 0 || n3 <= n2) {
            stringBuilder.append(string);
            return;
        }
        stringBuilder.append(string.substring(0, n2));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(10);
        if (!this.ralign) {
            stringBuilder.append('-');
        }
        if (this.width != 0) {
            stringBuilder.append(this.width);
        }
        if (this.precision > 0 && this.width != this.precision) {
            stringBuilder.append('.').append(this.precision);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append('s');
        }
        return stringBuilder.toString();
    }

    @Override
    public Object sample() {
        if (this.precision > 0) {
            return new LoremIpsum().toString(this.precision);
        }
        return new LoremIpsum().toString(this.width * 2 + 8);
    }
}

