/*
 * Decompiled with CFR 0.152.
 */
package io.sf.jclf.text.format;

import io.sf.jclf.text.format.NumberFormat;
import io.sf.jclf.text.format.SpecParsingException;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Random;

public class FloatFormat
extends NumberFormat {
    protected boolean numpre = false;
    private DecimalFormatSymbols symbols;

    public FloatFormat() {
        this.precision = 6;
        this.symbols = new DecimalFormatSymbols();
    }

    public static FloatFormat create(String string, Locale locale) throws SpecParsingException {
        return FloatFormat.create(string, new DecimalFormatSymbols(locale));
    }

    public static FloatFormat create(String string, DecimalFormatSymbols decimalFormatSymbols) throws SpecParsingException {
        FloatFormat floatFormat = (FloatFormat)FloatFormat.create(string);
        floatFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        return floatFormat;
    }

    @Override
    protected boolean setFlag(char c, int n) {
        if (!super.setFlag(c, n)) {
            switch (c) {
                case '#': {
                    this.numpre = true;
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public String format(Object object) {
        if (!(object instanceof Double) && !(object instanceof Float)) {
            throw new IllegalArgumentException("Object must be a Double or a Float");
        }
        return this.roundFixedPointNumber((Number)object);
    }

    private String roundFixedPointNumber(Number number) {
        StringBuilder stringBuilder;
        block41: {
            char c;
            int n;
            int n2;
            int n3;
            String string;
            block40: {
                int n4;
                double d = number.doubleValue();
                long l = Math.round(d * (double)this.getRoundingFactor());
                string = Long.toString(l).trim();
                n3 = string.length();
                if (l == 0L && this.precision == 0) {
                    StringBuilder stringBuilder2 = new StringBuilder(this.width);
                    for (int i = 0; i < this.width; ++i) {
                        stringBuilder2.append(' ');
                    }
                    return stringBuilder2.toString();
                }
                n2 = string.charAt(0) == '-' ? 1 : 0;
                n = 0;
                if (this.signpre || n2 == 1) {
                    n = 1;
                }
                c = this.symbols.getDecimalSeparator();
                stringBuilder = new StringBuilder(n3 >= this.width ? n3 + 1 : this.width + 1);
                if (n3 - n2 > this.precision) break block40;
                if (this.ralign) {
                    if (this.zeropadding) {
                        if (n2 == 1) {
                            stringBuilder.append('-');
                        } else if (this.signpre) {
                            stringBuilder.append('+');
                        }
                        for (n4 = this.precision + n + 2; n4 < this.width; ++n4) {
                            stringBuilder.append('0');
                        }
                    } else {
                        for (n4 = this.precision + n + 2; n4 < this.width; ++n4) {
                            stringBuilder.append(' ');
                        }
                        if (n2 == 1) {
                            stringBuilder.append('-');
                        } else if (this.signpre) {
                            stringBuilder.append('+');
                        }
                    }
                } else if (n2 == 1) {
                    stringBuilder.append('-');
                } else if (this.signpre) {
                    stringBuilder.append('+');
                }
                stringBuilder.append('0').append(c);
                for (n4 = n3 - n2; n4 < this.precision; ++n4) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(string.subSequence(n2, n3));
                if (this.ralign) break block41;
                for (n4 = n3 + this.precision + 1; n4 < this.width; ++n4) {
                    stringBuilder.append(' ');
                }
                break block41;
            }
            CharSequence charSequence = string.subSequence(n2, n3 - this.precision);
            CharSequence charSequence2 = string.subSequence(n3 - this.precision, n3);
            int n5 = charSequence.length() + charSequence2.length() + 1;
            if (this.ralign) {
                if (charSequence2.length() > 0) {
                    this.leftPadding(n2, n, n5, stringBuilder);
                    stringBuilder.append(charSequence).append(c).append(charSequence2);
                } else if (this.numpre) {
                    this.leftPadding(n2, n, n5, stringBuilder);
                    stringBuilder.append(charSequence).append(c);
                } else {
                    this.leftPadding(n2, n, n5 - 1, stringBuilder);
                    stringBuilder.append(charSequence);
                }
            } else {
                if (charSequence2.length() > 0) {
                    if (n2 == 1) {
                        stringBuilder.append('-');
                    } else if (this.signpre) {
                        stringBuilder.append('+');
                    }
                    stringBuilder.append(charSequence).append(c).append(charSequence2);
                } else if (this.numpre) {
                    if (n2 == 1) {
                        stringBuilder.append('-');
                    } else if (this.signpre) {
                        stringBuilder.append('+');
                    }
                    stringBuilder.append(charSequence).append(c);
                } else {
                    stringBuilder.append(' ');
                    if (n2 == 1) {
                        stringBuilder.append('-');
                    } else if (this.signpre) {
                        stringBuilder.append('+');
                    }
                    stringBuilder.append(charSequence);
                }
                for (int i = n5; i < this.width; ++i) {
                    stringBuilder.append(' ');
                }
            }
        }
        return stringBuilder.toString();
    }

    private void leftPadding(int n, int n2, int n3, StringBuilder stringBuilder) {
        if (this.zeropadding) {
            if (n == 1) {
                stringBuilder.append('-');
            } else if (this.signpre) {
                stringBuilder.append('+');
            }
            for (int i = n3 + n2; i < this.width; ++i) {
                stringBuilder.append('0');
            }
        } else {
            for (int i = n3 + n2; i < this.width; ++i) {
                stringBuilder.append(' ');
            }
            if (n == 1) {
                stringBuilder.append('-');
            } else if (this.signpre) {
                stringBuilder.append('+');
            }
        }
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        this.symbols = decimalFormatSymbols;
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        return this.symbols;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.ralign) {
            stringBuilder.append('-');
        }
        if (this.numpre) {
            stringBuilder.append('#');
        }
        if (this.zeropadding) {
            stringBuilder.append('0');
        }
        if (this.width != 0) {
            stringBuilder.append(this.width);
        }
        if (this.precision >= 0) {
            stringBuilder.append('.').append(this.precision);
        }
        stringBuilder.append('f');
        return stringBuilder.toString();
    }

    @Override
    public Object sample() {
        return new Random().nextDouble() * 10.0;
    }
}

