/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.spi;

import io.sf.carte.echosvg.ext.awt.image.URLImageCache;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.ext.awt.image.spi.BrokenLinkProvider;
import io.sf.carte.echosvg.ext.awt.image.spi.DefaultBrokenLinkProvider;
import io.sf.carte.echosvg.ext.awt.image.spi.ErrorConstants;
import io.sf.carte.echosvg.ext.awt.image.spi.JDKRegistryEntry;
import io.sf.carte.echosvg.ext.awt.image.spi.RegistryEntry;
import io.sf.carte.echosvg.ext.awt.image.spi.StreamRegistryEntry;
import io.sf.carte.echosvg.ext.awt.image.spi.URLRegistryEntry;
import io.sf.carte.echosvg.util.ParsedURL;
import java.awt.color.ColorSpace;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.ServiceLoader;
import java.util.concurrent.locks.ReentrantLock;

public class ImageTagRegistry
implements ErrorConstants {
    private List<RegistryEntry> entries = new LinkedList<RegistryEntry>();
    private List<String> extensions = null;
    private List<String> mimeTypes = null;
    private transient ReentrantLock regLock = new ReentrantLock();
    private final URLImageCache imgCache = new URLImageCache();
    private static final ImageTagRegistry registry = ImageTagRegistry.createImageTagRegistry();
    private static BrokenLinkProvider defaultProvider = new DefaultBrokenLinkProvider();
    private static BrokenLinkProvider brokenLinkProvider = null;

    ImageTagRegistry() {
    }

    public void flushCache() {
        this.imgCache.flush();
    }

    public void flushImage(ParsedURL parsedURL) {
        this.imgCache.clear(parsedURL);
    }

    public Filter checkCache(ParsedURL parsedURL) {
        Filter filter = this.imgCache.request(parsedURL);
        if (filter == null) {
            this.imgCache.clear(parsedURL);
        }
        return filter;
    }

    public Filter readURL(ParsedURL parsedURL) {
        return this.readURL(null, parsedURL, null, true, true);
    }

    public Filter readURL(InputStream inputStream, ParsedURL parsedURL, ColorSpace colorSpace, boolean bl, boolean bl2) {
        if (inputStream != null && !inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        Filter filter = null;
        if (parsedURL != null && (filter = this.imgCache.request(parsedURL)) != null) {
            return filter;
        }
        boolean bl3 = false;
        List<String> list = this.getRegisteredMimeTypes();
        for (RegistryEntry registryEntry : this.entries) {
            RegistryEntry registryEntry2;
            if (registryEntry instanceof URLRegistryEntry) {
                if (parsedURL == null || !bl || !(registryEntry2 = (URLRegistryEntry)registryEntry).isCompatibleURL(parsedURL) || (filter = registryEntry2.handleURL(parsedURL)) == null) continue;
                break;
            }
            if (!(registryEntry instanceof StreamRegistryEntry)) continue;
            registryEntry2 = (StreamRegistryEntry)registryEntry;
            if (bl3) continue;
            try {
                if (inputStream == null) {
                    if (parsedURL == null || !bl) break;
                    try {
                        inputStream = parsedURL.openStream(list.iterator());
                    }
                    catch (IOException iOException) {
                        bl3 = true;
                        continue;
                    }
                    if (!inputStream.markSupported()) {
                        inputStream = new BufferedInputStream(inputStream);
                    }
                }
                if (!registryEntry2.isCompatibleStream(inputStream) || (filter = registryEntry2.handleStream(inputStream, parsedURL, colorSpace)) == null) continue;
                break;
            }
            catch (StreamCorruptedException streamCorruptedException) {
                inputStream = null;
            }
        }
        if (parsedURL != null) {
            this.imgCache.put(parsedURL, filter);
        }
        if (filter == null) {
            if (!bl2) {
                return null;
            }
            if (bl3) {
                return ImageTagRegistry.getBrokenLinkImage(this, "url.unreachable", null);
            }
            return ImageTagRegistry.getBrokenLinkImage(this, "url.uninterpretable", null);
        }
        if (!bl2 && BrokenLinkProvider.hasBrokenLinkProperty(filter)) {
            filter = null;
        }
        return filter;
    }

    public Filter readStream(InputStream inputStream) {
        return this.readStream(inputStream, null);
    }

    public Filter readStream(InputStream inputStream, ColorSpace colorSpace) {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        Filter filter = null;
        for (RegistryEntry registryEntry : this.entries) {
            if (!(registryEntry instanceof StreamRegistryEntry)) continue;
            StreamRegistryEntry streamRegistryEntry = (StreamRegistryEntry)registryEntry;
            try {
                if (!streamRegistryEntry.isCompatibleStream(inputStream) || (filter = streamRegistryEntry.handleStream(inputStream, null, colorSpace)) == null) continue;
            }
            catch (StreamCorruptedException streamCorruptedException) {}
            break;
        }
        if (filter == null) {
            filter = ImageTagRegistry.getBrokenLinkImage(this, "stream.unreadable", null);
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(RegistryEntry registryEntry) {
        float f = registryEntry.getPriority();
        this.regLock.lock();
        try {
            ListIterator<RegistryEntry> listIterator = this.entries.listIterator();
            while (listIterator.hasNext()) {
                RegistryEntry registryEntry2 = listIterator.next();
                if (!(registryEntry2.getPriority() > f)) continue;
                listIterator.previous();
                break;
            }
            listIterator.add(registryEntry);
            this.extensions = null;
            this.mimeTypes = null;
        }
        finally {
            this.regLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getRegisteredExtensions() {
        List<String> list = this.extensions;
        if (list != null) {
            return list;
        }
        this.regLock.lock();
        try {
            if (this.extensions != null) {
                List<String> list2 = this.extensions;
                return list2;
            }
            this.extensions = new ArrayList<String>(this.entries.size() + 5);
            for (RegistryEntry registryEntry : this.entries) {
                this.extensions.addAll(registryEntry.getStandardExtensions());
            }
            this.extensions = Collections.unmodifiableList(this.extensions);
        }
        finally {
            this.regLock.unlock();
        }
        return this.extensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getRegisteredMimeTypes() {
        List<String> list = this.mimeTypes;
        if (list != null) {
            return list;
        }
        this.regLock.lock();
        try {
            if (this.mimeTypes != null) {
                List<String> list2 = this.mimeTypes;
                return list2;
            }
            this.mimeTypes = new ArrayList<String>(this.entries.size() + 5);
            for (RegistryEntry registryEntry : this.entries) {
                this.mimeTypes.addAll(registryEntry.getMimeTypes());
            }
            this.mimeTypes = Collections.unmodifiableList(this.mimeTypes);
        }
        finally {
            this.regLock.unlock();
        }
        return this.mimeTypes;
    }

    public static ImageTagRegistry getRegistry() {
        return registry;
    }

    private static ImageTagRegistry createImageTagRegistry() {
        ImageTagRegistry imageTagRegistry = new ImageTagRegistry();
        imageTagRegistry.register(new JDKRegistryEntry());
        ServiceLoader<RegistryEntry> serviceLoader = ServiceLoader.load(RegistryEntry.class);
        for (RegistryEntry registryEntry : serviceLoader) {
            imageTagRegistry.register(registryEntry);
        }
        return imageTagRegistry;
    }

    public static Filter getBrokenLinkImage(Object object, String string, Object[] objectArray) {
        Filter filter = null;
        if (brokenLinkProvider != null) {
            filter = brokenLinkProvider.getBrokenLinkImage(object, string, objectArray);
        }
        if (filter == null) {
            filter = defaultProvider.getBrokenLinkImage(object, string, objectArray);
        }
        return filter;
    }

    public static void setBrokenLinkProvider(BrokenLinkProvider brokenLinkProvider) {
        ImageTagRegistry.brokenLinkProvider = brokenLinkProvider;
    }
}

