/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image;

import io.sf.carte.echosvg.ext.awt.image.TransferFunction;

public class TableTransfer
implements TransferFunction {
    public byte[] lutData;
    public int[] tableValues;
    private int n;

    public TableTransfer(int[] nArray) {
        this.tableValues = nArray;
        this.n = nArray.length;
    }

    private void buildLutData() {
        this.lutData = new byte[256];
        for (int i = 0; i <= 255; ++i) {
            float f = (float)(i * (this.n - 1)) / 255.0f;
            int n = (int)Math.floor(f);
            int n2 = n + 1 > this.n - 1 ? this.n - 1 : n + 1;
            float f2 = f - (float)n;
            this.lutData[i] = (byte)((int)((float)this.tableValues[n] + f2 * (float)(this.tableValues[n2] - this.tableValues[n])) & 0xFF);
        }
    }

    @Override
    public byte[] getLookupTable() {
        this.buildLutData();
        return this.lutData;
    }
}

