/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.parser;

import io.sf.carte.echosvg.parser.CalcParseException;
import io.sf.carte.echosvg.parser.NumberParser;
import io.sf.carte.echosvg.parser.ParseException;
import io.sf.carte.echosvg.parser.PointsHandler;
import java.io.IOException;
import org.w3c.css.om.unit.CSSUnit;

public class PointsParser
extends NumberParser {
    private PointsHandler pointsHandler;
    protected boolean eRead;
    private boolean processingY = false;
    private float lastX;

    public PointsParser(PointsHandler pointsHandler) {
        this.pointsHandler = pointsHandler;
    }

    public void setPointsHandler(PointsHandler pointsHandler) {
        this.pointsHandler = pointsHandler;
    }

    public PointsHandler getPointsHandler() {
        return this.pointsHandler;
    }

    @Override
    protected void doParse() throws ParseException, IOException {
        this.pointsHandler.startPoints();
        this.current = this.reader.read();
        this.skipSpaces();
        while (this.current != -1) {
            float f;
            float f2;
            try {
                f2 = this.parseFloat();
            }
            catch (CalcParseException calcParseException) {
                this.processingY = false;
                this.cssParse();
                this.pointsHandler.endPoints();
                return;
            }
            this.skipCommaSpaces();
            try {
                f = this.parseFloat();
            }
            catch (CalcParseException calcParseException) {
                this.lastX = f2;
                this.processingY = true;
                this.cssParse();
                this.pointsHandler.endPoints();
                return;
            }
            this.pointsHandler.point(f2, f);
            this.skipCommaSpaces();
        }
        this.pointsHandler.endPoints();
    }

    @Override
    protected void handleNumber(short s, float f) throws ParseException {
        if (s != 0) {
            throw new ParseException(this.createErrorMessage("dimension.not.number", new Object[]{CSSUnit.dimensionUnitString((short)s)}), -1, -1);
        }
        if (this.processingY) {
            this.pointsHandler.point(this.lastX, f);
        } else {
            this.lastX = f;
        }
        this.processingY = !this.processingY;
    }
}

