/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.ScriptRuntimeES6;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.typedarrays.ByteIo;
import org.mozilla.javascript.typedarrays.NativeArrayBuffer;
import org.mozilla.javascript.typedarrays.NativeTypedArrayView;

public class NativeFloat32Array
extends NativeTypedArrayView<Float> {
    private static final long serialVersionUID = -8963461831950499340L;
    private static final String CLASS_NAME = "Float32Array";
    private static final int BYTES_PER_ELEMENT = 4;

    public NativeFloat32Array() {
    }

    public NativeFloat32Array(NativeArrayBuffer nativeArrayBuffer, int n, int n2) {
        super(nativeArrayBuffer, n, n2, n2 * 4);
    }

    public NativeFloat32Array(int n) {
        this(new NativeArrayBuffer((double)n * 4.0), 0, n);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeFloat32Array nativeFloat32Array = new NativeFloat32Array();
        IdFunctionObject idFunctionObject = nativeFloat32Array.exportAsJSClass(7, scriptable, bl);
        ScriptRuntimeES6.addSymbolSpecies(context, scriptable, idFunctionObject);
    }

    protected NativeFloat32Array construct(NativeArrayBuffer nativeArrayBuffer, int n, int n2) {
        return new NativeFloat32Array(nativeArrayBuffer, n, n2);
    }

    @Override
    public int getBytesPerElement() {
        return 4;
    }

    protected NativeFloat32Array realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        return NativeFloat32Array.ensureType(scriptable, NativeFloat32Array.class, idFunctionObject);
    }

    @Override
    protected Object js_get(int n) {
        if (this.checkIndex(n)) {
            return Undefined.instance;
        }
        return ByteIo.readFloat32(this.arrayBuffer.buffer, n * 4 + this.offset, NativeFloat32Array.useLittleEndian());
    }

    @Override
    protected Object js_set(int n, Object object) {
        if (this.checkIndex(n)) {
            return Undefined.instance;
        }
        double d = ScriptRuntime.toNumber(object);
        ByteIo.writeFloat32(this.arrayBuffer.buffer, n * 4 + this.offset, d, NativeFloat32Array.useLittleEndian());
        return null;
    }

    @Override
    public Float get(int n) {
        if (this.checkIndex(n)) {
            throw new IndexOutOfBoundsException();
        }
        return (Float)this.js_get(n);
    }

    @Override
    public Float set(int n, Float f) {
        if (this.checkIndex(n)) {
            throw new IndexOutOfBoundsException();
        }
        return (Float)this.js_set(n, f);
    }
}

