/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.export.mindmapmode;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.CaseSensitiveFileNameExtensionFilter;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.export.mindmapmode.ExportController;
import org.freeplane.features.export.mindmapmode.XsltExportEngine;

class XsltExportEngineFactory {
    private static final String EXPORT_FILTER_PATTERN = "^.*MINDMAPEXPORTFILTER\\s+(\\S+)\\s+(.*)(?:\\s+-->)?$";
    private static final String FILE_NAME_PATTERN = "mm2([\\w]+)\\.xsl";
    private static final Pattern COMPILED_EXPORT_FILTER_PATTERN = Pattern.compile("^.*MINDMAPEXPORTFILTER\\s+(\\S+)\\s+(.*)(?:\\s+-->)?$");
    private static final Pattern COMPILED_FILE_NAME_PATTERN = Pattern.compile("mm2([\\w]+)\\.xsl");
    private static final int MAX_READ_LINES = 5;
    private ExportController controller;

    XsltExportEngineFactory() {
    }

    void gatherXsltScripts(ExportController controller) {
        try {
            this.controller = controller;
            this.gatherXsltScripts(this.getXsltUserDirectory());
            this.gatherXsltScripts(this.getXsltSysDirectory());
        }
        finally {
            this.controller = null;
        }
    }

    File getXsltSysDirectory() {
        return new File(ResourceController.getResourceController().getResourceBaseDir(), "xslt");
    }

    File getXsltUserDirectory() {
        return new File(ResourceController.getResourceController().getFreeplaneUserDirectory(), "xslt");
    }

    private void gatherXsltScripts(File xsltdir) {
        if (!xsltdir.isDirectory() || !xsltdir.canRead()) {
            return;
        }
        File[] xsltFiles = xsltdir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.canRead() && pathname.getPath().toLowerCase().endsWith(".xsl");
            }
        });
        for (int i = 0; i < xsltFiles.length; ++i) {
            this.extractFilterFromFile(xsltFiles[i]);
        }
    }

    private void extractFilterFromFile(File xsltFile) {
        try (BufferedReader xsl = new BufferedReader(new FileReader(xsltFile));){
            String description;
            Matcher m;
            String line;
            boolean keyFound = false;
            for (int l = 0; (line = xsl.readLine()) != null && l < 5; ++l) {
                m = COMPILED_EXPORT_FILTER_PATTERN.matcher(line);
                if (!m.matches()) continue;
                keyFound = true;
                String[] extensions = m.group(1).split("\\s*;\\s*");
                description = m.group(2).trim();
                if (description.startsWith("%")) {
                    description = TextUtils.getText((String)description.substring(1));
                }
                this.addXsltFile(extensions, description, xsltFile);
                --l;
            }
            if (keyFound) {
                return;
            }
            m = COMPILED_FILE_NAME_PATTERN.matcher(xsltFile.getName());
            if (m.matches()) {
                String extension = m.group(1);
                description = TextUtils.format((String)"exported_file", (Object[])new Object[]{extension});
                this.addXsltFile(new String[]{extension}, description, xsltFile);
            }
        }
        catch (IOException e) {
            LogUtils.warn((Throwable)e);
            UITools.errorMessage((Object)TextUtils.getText((String)"export_failed"));
        }
    }

    private void addXsltFile(String[] extensions, String description, File xsltFile) {
        CaseSensitiveFileNameExtensionFilter filter = new CaseSensitiveFileNameExtensionFilter(extensions, TextUtils.getOptionalTranslation((String)description));
        XsltExportEngine exporter = new XsltExportEngine(xsltFile);
        this.controller.addMapExportEngine((javax.swing.filechooser.FileFilter)filter, exporter);
        this.controller.addBranchExportEngine((javax.swing.filechooser.FileFilter)filter, exporter);
    }
}

