﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once

#include <aws/core/client/AWSError.h>
#include <aws/core/client/CoreErrors.h>
#include <aws/cloudtrail/CloudTrail_EXPORTS.h>

namespace Aws
{
namespace CloudTrail
{
enum class CloudTrailErrors
{
  //From Core//
  //////////////////////////////////////////////////////////////////////////////////////////
  INCOMPLETE_SIGNATURE = 0,
  INTERNAL_FAILURE = 1,
  INVALID_ACTION = 2,
  INVALID_CLIENT_TOKEN_ID = 3,
  INVALID_PARAMETER_COMBINATION = 4,
  INVALID_QUERY_PARAMETER = 5,
  INVALID_PARAMETER_VALUE = 6,
  MISSING_ACTION = 7, // SDK should never allow
  MISSING_AUTHENTICATION_TOKEN = 8, // SDK should never allow
  MISSING_PARAMETER = 9, // SDK should never allow
  OPT_IN_REQUIRED = 10,
  REQUEST_EXPIRED = 11,
  SERVICE_UNAVAILABLE = 12,
  THROTTLING = 13,
  VALIDATION = 14,
  ACCESS_DENIED = 15,
  RESOURCE_NOT_FOUND = 16,
  UNRECOGNIZED_CLIENT = 17,
  MALFORMED_QUERY_STRING = 18,
  SLOW_DOWN = 19,
  REQUEST_TIME_TOO_SKEWED = 20,
  INVALID_SIGNATURE = 21,
  SIGNATURE_DOES_NOT_MATCH = 22,
  INVALID_ACCESS_KEY_ID = 23,
  REQUEST_TIMEOUT = 24,
  NETWORK_CONNECTION = 99,

  UNKNOWN = 100,
  ///////////////////////////////////////////////////////////////////////////////////////////

  ACCOUNT_HAS_ONGOING_IMPORT= static_cast<int>(Aws::Client::CoreErrors::SERVICE_EXTENSION_START_RANGE) + 1,
  ACCOUNT_NOT_FOUND,
  ACCOUNT_NOT_REGISTERED,
  ACCOUNT_REGISTERED,
  CANNOT_DELEGATE_MANAGEMENT_ACCOUNT,
  CHANNEL_ALREADY_EXISTS,
  CHANNEL_A_R_N_INVALID,
  CHANNEL_EXISTS_FOR_E_D_S,
  CHANNEL_MAX_LIMIT_EXCEEDED,
  CHANNEL_NOT_FOUND,
  CLOUD_TRAIL_ACCESS_NOT_ENABLED,
  CLOUD_TRAIL_A_R_N_INVALID,
  CLOUD_TRAIL_INVALID_CLIENT_TOKEN_ID,
  CLOUD_WATCH_LOGS_DELIVERY_UNAVAILABLE,
  CONCURRENT_MODIFICATION,
  CONFLICT,
  DELEGATED_ADMIN_ACCOUNT_LIMIT_EXCEEDED,
  EVENT_DATA_STORE_ALREADY_EXISTS,
  EVENT_DATA_STORE_A_R_N_INVALID,
  EVENT_DATA_STORE_FEDERATION_ENABLED,
  EVENT_DATA_STORE_HAS_ONGOING_IMPORT,
  EVENT_DATA_STORE_MAX_LIMIT_EXCEEDED,
  EVENT_DATA_STORE_NOT_FOUND,
  EVENT_DATA_STORE_TERMINATION_PROTECTED,
  GENERATE_RESPONSE,
  IMPORT_NOT_FOUND,
  INACTIVE_EVENT_DATA_STORE,
  INACTIVE_QUERY,
  INSIGHT_NOT_ENABLED,
  INSUFFICIENT_DEPENDENCY_SERVICE_ACCESS_PERMISSION,
  INSUFFICIENT_ENCRYPTION_POLICY,
  INSUFFICIENT_S3_BUCKET_POLICY,
  INSUFFICIENT_SNS_TOPIC_POLICY,
  INVALID_CLOUD_WATCH_LOGS_LOG_GROUP_ARN,
  INVALID_CLOUD_WATCH_LOGS_ROLE_ARN,
  INVALID_DATE_RANGE,
  INVALID_EVENT_CATEGORY,
  INVALID_EVENT_DATA_STORE_CATEGORY,
  INVALID_EVENT_DATA_STORE_STATUS,
  INVALID_EVENT_SELECTORS,
  INVALID_HOME_REGION,
  INVALID_IMPORT_SOURCE,
  INVALID_INSIGHT_SELECTORS,
  INVALID_KMS_KEY_ID,
  INVALID_LOOKUP_ATTRIBUTES,
  INVALID_MAX_RESULTS,
  INVALID_NEXT_TOKEN,
  INVALID_PARAMETER,
  INVALID_QUERY_STATEMENT,
  INVALID_QUERY_STATUS,
  INVALID_S3_BUCKET_NAME,
  INVALID_S3_PREFIX,
  INVALID_SNS_TOPIC_NAME,
  INVALID_SOURCE,
  INVALID_TAG_PARAMETER,
  INVALID_TIME_RANGE,
  INVALID_TOKEN,
  INVALID_TRAIL_NAME,
  KMS,
  KMS_KEY_DISABLED,
  KMS_KEY_NOT_FOUND,
  MAXIMUM_NUMBER_OF_TRAILS_EXCEEDED,
  MAX_CONCURRENT_QUERIES,
  NOT_ORGANIZATION_MANAGEMENT_ACCOUNT,
  NOT_ORGANIZATION_MASTER_ACCOUNT,
  NO_MANAGEMENT_ACCOUNT_S_L_R_EXISTS,
  OPERATION_NOT_PERMITTED,
  ORGANIZATIONS_NOT_IN_USE,
  ORGANIZATION_NOT_IN_ALL_FEATURES_MODE,
  QUERY_ID_NOT_FOUND,
  RESOURCE_A_R_N_NOT_VALID,
  RESOURCE_POLICY_NOT_FOUND,
  RESOURCE_POLICY_NOT_VALID,
  RESOURCE_TYPE_NOT_SUPPORTED,
  S3_BUCKET_DOES_NOT_EXIST,
  SERVICE_QUOTA_EXCEEDED,
  TAGS_LIMIT_EXCEEDED,
  TRAIL_ALREADY_EXISTS,
  TRAIL_NOT_FOUND,
  TRAIL_NOT_PROVIDED,
  UNSUPPORTED_OPERATION
};

class AWS_CLOUDTRAIL_API CloudTrailError : public Aws::Client::AWSError<CloudTrailErrors>
{
public:
  CloudTrailError() {}
  CloudTrailError(const Aws::Client::AWSError<Aws::Client::CoreErrors>& rhs) : Aws::Client::AWSError<CloudTrailErrors>(rhs) {}
  CloudTrailError(Aws::Client::AWSError<Aws::Client::CoreErrors>&& rhs) : Aws::Client::AWSError<CloudTrailErrors>(rhs) {}
  CloudTrailError(const Aws::Client::AWSError<CloudTrailErrors>& rhs) : Aws::Client::AWSError<CloudTrailErrors>(rhs) {}
  CloudTrailError(Aws::Client::AWSError<CloudTrailErrors>&& rhs) : Aws::Client::AWSError<CloudTrailErrors>(rhs) {}

  template <typename T>
  T GetModeledError();
};

namespace CloudTrailErrorMapper
{
  AWS_CLOUDTRAIL_API Aws::Client::AWSError<Aws::Client::CoreErrors> GetErrorForName(const char* errorName);
}

} // namespace CloudTrail
} // namespace Aws
