﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/clouddirectory/CloudDirectory_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/clouddirectory/model/TypedLinkSpecifier.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace CloudDirectory
{
namespace Model
{
  class ListOutgoingTypedLinksResult
  {
  public:
    AWS_CLOUDDIRECTORY_API ListOutgoingTypedLinksResult() = default;
    AWS_CLOUDDIRECTORY_API ListOutgoingTypedLinksResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_CLOUDDIRECTORY_API ListOutgoingTypedLinksResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>Returns a typed link specifier as output.</p>
     */
    inline const Aws::Vector<TypedLinkSpecifier>& GetTypedLinkSpecifiers() const { return m_typedLinkSpecifiers; }
    template<typename TypedLinkSpecifiersT = Aws::Vector<TypedLinkSpecifier>>
    void SetTypedLinkSpecifiers(TypedLinkSpecifiersT&& value) { m_typedLinkSpecifiersHasBeenSet = true; m_typedLinkSpecifiers = std::forward<TypedLinkSpecifiersT>(value); }
    template<typename TypedLinkSpecifiersT = Aws::Vector<TypedLinkSpecifier>>
    ListOutgoingTypedLinksResult& WithTypedLinkSpecifiers(TypedLinkSpecifiersT&& value) { SetTypedLinkSpecifiers(std::forward<TypedLinkSpecifiersT>(value)); return *this;}
    template<typename TypedLinkSpecifiersT = TypedLinkSpecifier>
    ListOutgoingTypedLinksResult& AddTypedLinkSpecifiers(TypedLinkSpecifiersT&& value) { m_typedLinkSpecifiersHasBeenSet = true; m_typedLinkSpecifiers.emplace_back(std::forward<TypedLinkSpecifiersT>(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The pagination token.</p>
     */
    inline const Aws::String& GetNextToken() const { return m_nextToken; }
    template<typename NextTokenT = Aws::String>
    void SetNextToken(NextTokenT&& value) { m_nextTokenHasBeenSet = true; m_nextToken = std::forward<NextTokenT>(value); }
    template<typename NextTokenT = Aws::String>
    ListOutgoingTypedLinksResult& WithNextToken(NextTokenT&& value) { SetNextToken(std::forward<NextTokenT>(value)); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const { return m_requestId; }
    template<typename RequestIdT = Aws::String>
    void SetRequestId(RequestIdT&& value) { m_requestIdHasBeenSet = true; m_requestId = std::forward<RequestIdT>(value); }
    template<typename RequestIdT = Aws::String>
    ListOutgoingTypedLinksResult& WithRequestId(RequestIdT&& value) { SetRequestId(std::forward<RequestIdT>(value)); return *this;}
    ///@}
  private:

    Aws::Vector<TypedLinkSpecifier> m_typedLinkSpecifiers;
    bool m_typedLinkSpecifiersHasBeenSet = false;

    Aws::String m_nextToken;
    bool m_nextTokenHasBeenSet = false;

    Aws::String m_requestId;
    bool m_requestIdHasBeenSet = false;
  };

} // namespace Model
} // namespace CloudDirectory
} // namespace Aws
